/*
 * Copyright 2013 eXo Platform SAS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sessionscope;

import juzu.SessionScoped;

import javax.inject.Named;
import java.io.Serializable;

/** @author Julien Viet */
@SessionScoped
@Named("FOO")
public class Session implements Serializable {

  /** . */
  int value = 0;

  @Override
  public String toString() {
    return "Session[" + value + "]";
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    } else if (obj instanceof Session) {
      Session that = (Session)obj;
      return value == that.value;
    } else {
      return false;
    }
  }
}
