/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.dialect.gtmpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import juzu.impl.common.Location;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.template.spi.juzu.DialectTemplateEmitter;
import juzu.impl.template.spi.juzu.ast.SectionType;
import juzu.impl.template.spi.juzu.dialect.gtmpl.Foo;
import juzu.impl.template.spi.juzu.dialect.gtmpl.GroovyTemplateStub;
import juzu.impl.template.spi.juzu.dialect.gtmpl.MessageKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyTemplateEmitter
extends DialectTemplateEmitter {
    private final String sep = System.getProperty("line.separator");
    private StringBuilder out = new StringBuilder();
    private List<String> texts = new ArrayList<String>();
    private List<String> messageKeys = new ArrayList<String>();
    private HashMap<Integer, Foo> locationTable = new HashMap();
    private int lineNumber = 1;
    private Location pos = null;
    private int closureCount = 0;
    private int closureCountIndex = -1;
    private final int[] closureCountStack = new int[200];
    private final Name pkg;
    private final Name constants;

    public GroovyTemplateEmitter() {
        this(null);
    }

    public GroovyTemplateEmitter(Name name) {
        if (name != null) {
            this.pkg = name.getParent();
            String id = "C" + name.getIdentifier();
            this.constants = this.pkg.append(id);
        } else {
            this.pkg = null;
            this.constants = Name.parse("Constants");
        }
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append(this.out.toString());
        builder.append(this.sep);
        builder.append("public static class ").append(this.constants.getIdentifier()).append(this.sep);
        builder.append("{").append(this.sep);
        for (i = 0; i < this.texts.size(); ++i) {
            String text = this.texts.get(i);
            builder.append("public static final ").append("String").append(" s").append(i).append(" = '");
            Tools.escape(text, builder);
            builder.append("';").append(this.sep);
        }
        for (i = 0; i < this.messageKeys.size(); ++i) {
            String messageKey = this.messageKeys.get(i);
            builder.append("public static final ").append(MessageKey.class.getName()).append(" m").append(i).append(" = new ").append(MessageKey.class.getName()).append("('");
            Tools.escape(messageKey, builder);
            builder.append("');").append(this.sep);
        }
        builder.append("public static final Map<Integer, ").append(Foo.class.getName()).append("> TABLE = ");
        if (this.locationTable.isEmpty()) {
            builder.append("[:]");
        } else {
            builder.append("[").append(this.sep);
            Iterator<Map.Entry<Integer, Foo>> i2 = this.locationTable.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry<Integer, Foo> entry = i2.next();
                Foo text = entry.getValue();
                Location location = text.getPosition();
                builder.append(entry.getKey()).append(':').append("new ").append(Foo.class.getName()).append("(").append("new ").append(Location.class.getName()).append("(").append(location.getCol()).append(',').append(location.getLine()).append("),").append("'");
                Tools.escape(text.getValue(), builder);
                builder.append("')");
                if (i2.hasNext()) {
                    builder.append(",").append(this.sep);
                    continue;
                }
                builder.append(']');
            }
        }
        builder.append(";").append(this.sep);
        builder.append("}").append(this.sep);
        return builder.toString();
    }

    public GroovyTemplateStub build(String templateId) {
        final String script = this.toString();
        return new GroovyTemplateStub(templateId){

            public String getScript(ClassLoader loader, String fqn) {
                return script;
            }
        };
    }

    @Override
    public void open() {
        if (this.pkg != null) {
            this.out.append("package ").append(this.pkg).append(";\n");
            ++this.lineNumber;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void openScriptlet(Location beginPosition) {
        this.pos = beginPosition;
    }

    @Override
    public void appendScriptlet(String scriptlet) {
        this.out.append(scriptlet);
        this.locationTable.put(this.lineNumber, new Foo(this.pos, scriptlet));
    }

    @Override
    public void closeScriptlet() {
        this.out.append(this.sep);
        ++this.lineNumber;
    }

    @Override
    public void openExpression(Location beginPosition) {
        this.pos = beginPosition;
        this.out.append(";out.print(\"${");
    }

    @Override
    public void appendExpression(String expr) {
        this.out.append(expr);
        this.locationTable.put(this.lineNumber, new Foo(this.pos, expr));
    }

    @Override
    public void closeExpression() {
        this.out.append("}\");").append(this.sep);
        ++this.lineNumber;
    }

    @Override
    public void appendText(String text) {
        this.out.append(";out.print(").append(this.constants).append(".s").append(this.texts.size()).append(");").append(this.sep);
        this.texts.add(text);
        ++this.lineNumber;
    }

    @Override
    public void appendLineBreak(SectionType currentType, Location position) {
        this.pos = new Location(1, position.getLine() + 1);
        switch (currentType) {
            case SCRIPTLET: {
                this.out.append(this.sep);
                ++this.lineNumber;
                break;
            }
            case EXPR: {
                this.out.append(this.sep);
                ++this.lineNumber;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void url(String typeName, String methodName, List<String> args) {
        this.out.append(";out.print(");
        this.out.append(typeName);
        this.out.append(".");
        this.out.append(methodName);
        this.out.append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                this.out.append(",");
            }
            String methodArg = args.get(i);
            this.out.append(methodArg);
        }
        this.out.append("));");
    }

    @Override
    public void message(String key) {
        this.out.append("out.print(").append(this.constants).append(".m").append(this.messageKeys.size()).append(");").append(this.sep);
        this.messageKeys.add(key);
    }

    @Override
    public void openTag(String className, Map<String, String> args) {
        int n = this.closureCount++;
        this.closureCountStack[++this.closureCountIndex] = n;
        int count = n;
        this.out.append("; def closure").append(count).append(" = { ");
    }

    @Override
    public void closeTag(String className, Map<String, String> args) {
        int count = this.closureCountStack[this.closureCountIndex--];
        this.out.append("; } as juzu.template.Renderable;");
        this.out.append("; new ").append(className).append("().render(out.renderContext, closure").append(count).append(",");
        if (args == null || args.isEmpty()) {
            this.out.append("null");
        } else {
            this.out.append("[");
            int index = 0;
            for (Map.Entry<String, String> entry : args.entrySet()) {
                if (index++ > 0) {
                    this.out.append(",");
                }
                this.out.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\".toString()");
            }
            this.out.append("]");
        }
        this.out.append(");");
    }

    @Override
    public void tag(String tagName, Map<String, String> args) {
    }
}

