/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.tools.FileObject;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.template.metamodel.ElementTemplateRefMetaModel;
import juzu.impl.plugin.template.metamodel.MetaModelProcessContext;
import juzu.impl.plugin.template.metamodel.TemplateEmitter;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModelPlugin;
import juzu.impl.plugin.template.metamodel.TemplateRefMetaModel;
import juzu.impl.template.spi.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatesMetaModel
extends MetaModelObject
implements Iterable<TemplateMetaModel> {
    private static final Logger log = BaseProcessor.getLogger(TemplateEmitter.class);
    public static final Key<TemplatesMetaModel> KEY = Key.of(TemplatesMetaModel.class);
    public static final Name LOCATION = Name.parse("templates");
    ApplicationMetaModel application;
    private Name qn;
    TemplateEmitter emitter;
    TemplateMetaModelPlugin plugin;

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.map("values", this.getChildren(TemplateMetaModel.class));
        json.set("qn", this.qn);
        return json;
    }

    public Path.Absolute resolvePath(Path path) {
        return this.qn.resolve(path);
    }

    public ApplicationMetaModel getApplication() {
        return this.application;
    }

    public Name getQN() {
        return this.qn;
    }

    public TemplateMetaModel get(Path path) {
        return this.getChild(Key.of(path, TemplateMetaModel.class));
    }

    @Override
    public Iterator<TemplateMetaModel> iterator() {
        return this.getChildren(TemplateMetaModel.class).iterator();
    }

    public void remove(ElementHandle.Field handle) {
        Key<TemplateRefMetaModel> key = Key.of(handle, TemplateRefMetaModel.class);
        TemplateRefMetaModel ref = this.getChild(key);
        TemplateMetaModel template = ref.getChild(TemplateMetaModel.KEY);
        this.removeChild(key);
        if (template.refCount == 0) {
            template.remove();
        }
    }

    void resolve() {
        log.log("Synchronizing existing templates");
        for (final TemplateMetaModel child : this.getChildren(TemplateMetaModel.class)) {
            if (child.template == null) continue;
            Template<?> template = child.template;
            FileObject resource = this.application.resolveResource(LOCATION, template.getRelativePath());
            if (resource == null) {
                child.template = null;
                log.log("Detected template removal " + template.getRelativePath());
                continue;
            }
            if (resource.getLastModified() > template.getLastModified()) {
                child.template = null;
                log.log("Detected stale template " + template.getRelativePath());
                continue;
            }
            log.log("Template " + template.getRelativePath() + " is valid");
        }
        for (final TemplateMetaModel child : this.getChildren(TemplateMetaModel.class)) {
            if (child.template != null) continue;
            final MetaModelProcessContext processContext = new MetaModelProcessContext(this);
            this.application.getProcessingContext().executeWithin(child.getReferencingElements()[0], new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    processContext.resolve(child);
                    return null;
                }
            });
        }
    }

    public TemplateRefMetaModel add(ElementHandle.Field handle, Path.Relative path) {
        TemplateRefMetaModel ref = this.addChild(Key.of(handle, TemplateRefMetaModel.class), new ElementTemplateRefMetaModel(handle, path));
        return this.add(ref, path);
    }

    public TemplateMetaModel add(TemplateRefMetaModel ref, Path.Relative path) {
        TemplateMetaModel template = this.add(path);
        ref.addChild(TemplateMetaModel.KEY, template);
        return template;
    }

    public TemplateMetaModel add(Path.Relative path) {
        TemplateMetaModel template = this.getChild(Key.of(path, TemplateMetaModel.class));
        if (template == null) {
            template = this.addChild(Key.of(path, TemplateMetaModel.class), new TemplateMetaModel(path));
        }
        return template;
    }

    public void remove(TemplateMetaModel template) {
        if (template.templates != this) {
            throw new IllegalArgumentException();
        }
        this.removeChild(Key.of(template.path, TemplateMetaModel.class));
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        if (parent instanceof ApplicationMetaModel) {
            this.application = (ApplicationMetaModel)parent;
            this.qn = this.application.getName().append(LOCATION);
            this.emitter = new TemplateEmitter(this);
        }
    }
}

