/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.Filter;
import juzu.impl.fs.Visitor;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.jar.JarFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadFileSystem<P> {
    public static final int DIR = 0;
    public static final int FILE = 1;
    public static final int PATH = 2;
    private static final Filter NULL = new Filter.Default();
    private final Charset encoding = Charset.defaultCharset();

    public static ReadFileSystem<?> create(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            int pos;
            String path = url.getPath();
            URL nested = new URL(path.substring(0, pos = path.lastIndexOf("!/")));
            if (nested.getProtocol().equals("file")) {
                return new JarFileSystem(url);
            }
            throw new IOException("Cannot handle nested jar URL " + url);
        }
        if (protocol.equals("file")) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            if (f.isDirectory()) {
                return new DiskFileSystem(f);
            }
            return new JarFileSystem(url);
        }
        throw new IOException("Unsupported URL: " + url);
    }

    protected ReadFileSystem() {
    }

    public final Charset getEncoding() {
        return this.encoding;
    }

    public abstract boolean equals(P var1, P var2);

    public abstract P getRoot() throws IOException;

    public abstract P getChild(P var1, String var2) throws IOException;

    public abstract long getLastModified(P var1) throws IOException;

    public abstract Class<P> getType();

    public abstract String getDescription();

    public abstract String getName(P var1);

    public abstract Iterator<P> getChildren(P var1) throws IOException;

    public abstract PathType typeOf(P var1) throws IOException;

    public abstract Timestamped<Content> getContent(P var1) throws IOException;

    public abstract File getFile(P var1);

    public abstract URL getURL(P var1) throws NullPointerException, IOException;

    public final boolean isDir(P path) throws IOException {
        return this.typeOf(path) == PathType.DIR;
    }

    public final boolean isFile(P path) throws IOException {
        return this.typeOf(path) == PathType.FILE;
    }

    public final void dump(Appendable appendable) throws IOException {
        this.dump(this.getRoot(), appendable);
    }

    public final void dump(P path, final Appendable appendable) throws IOException {
        final StringBuilder prefix = new StringBuilder();
        this.traverse(path, new Visitor<P>(){

            @Override
            public void enterDir(P dir, String name) throws IOException {
                if (name.length() > 0) {
                    prefix.append('/').append(name);
                }
            }

            @Override
            public void file(P file, String name) throws IOException {
                appendable.append(prefix).append(name).append("\n");
            }

            @Override
            public void leaveDir(P dir, String name) throws IOException {
                if (name.length() > 0) {
                    prefix.setLength(prefix.length() - 1 - name.length());
                }
            }
        });
    }

    public final Timestamped<Content> getContent(Iterable<String> names) throws IOException {
        P path = this.getPath(names);
        if (path != null && this.isFile(path)) {
            return this.getContent(path);
        }
        return null;
    }

    public final P getPath(String ... names) throws IOException {
        return this.getPath(Arrays.asList(names));
    }

    public final P getPath(Iterable<String> names) throws IOException {
        return this.getPath(this.getRoot(), names);
    }

    public final P getPath(P from, String ... names) throws IOException {
        return this.getPath(from, Arrays.asList(names));
    }

    public final P getPath(P from, Iterable<String> names) throws IOException {
        for (String name : names) {
            if (this.isDir(from)) {
                P child = this.getChild(from, name);
                if (child != null) {
                    from = child;
                    continue;
                }
                return null;
            }
            throw new UnsupportedOperationException("handle me gracefully : was expecting " + Tools.list(names) + " to resolve");
        }
        return from;
    }

    public final int size(final int mode) throws IOException {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode " + mode);
            }
        }
        final AtomicInteger size = new AtomicInteger();
        this.traverse(new Visitor.Default<P>(){

            @Override
            public void enterDir(P dir, String name) throws IOException {
                if (ReadFileSystem.this.getLastModified(dir) > 0L && (mode == 2 || mode == 0)) {
                    size.incrementAndGet();
                }
            }

            @Override
            public void file(P file, String name) throws IOException {
                if (ReadFileSystem.this.getLastModified(file) > 0L && (mode == 2 || mode == 1)) {
                    size.incrementAndGet();
                }
            }
        });
        return size.get();
    }

    public final void traverse(Filter<P> filter, Visitor<P> visitor) throws IOException {
        this.traverse(this.getRoot(), filter, visitor);
    }

    public final void traverse(Visitor<P> visitor) throws IOException {
        this.traverse(this.getRoot(), visitor);
    }

    public final void traverse(P path, Visitor<P> visitor) throws IOException {
        Filter filter = NULL;
        this.traverse(path, filter, visitor);
    }

    public final void traverse(P path, Filter<P> filter, Visitor<P> visitor) throws IOException {
        String name = this.getName(path);
        if (this.isDir(path)) {
            if (filter.acceptDir(path, name)) {
                visitor.enterDir(path, name);
                Iterator<P> i = this.getChildren(path);
                while (i.hasNext()) {
                    P child = i.next();
                    this.traverse(child, filter, visitor);
                }
                visitor.leaveDir(path, name);
            }
        } else if (filter.acceptFile(path, name)) {
            visitor.file(path, name);
        }
    }

    public <D> void copy(ReadWriteFileSystem<D> dst) throws IOException {
        this.copy(new Filter.Default(), dst);
    }

    public <D> void copy(ReadWriteFileSystem<D> dst, D dstPath) throws IOException {
        this.copy(this.getRoot(), new Filter.Default(), dst, dstPath);
    }

    public <D> void copy(Filter<P> filter, ReadWriteFileSystem<D> dst) throws IOException {
        this.copy(this.getRoot(), filter, dst, dst.getRoot());
    }

    public <D> void copy(P srcPath, Filter<P> filter, ReadWriteFileSystem<D> dst, D dstPath) throws IOException {
        int kind = this.kind(srcPath, dst, dstPath);
        String srcName = this.getName(srcPath);
        switch (kind) {
            case 0: {
                if (!filter.acceptFile(srcPath, srcName)) break;
                dst.setContent(dstPath, this.getContent(srcPath).getObject());
                break;
            }
            case 1: {
                Object a;
                String name;
                Object next;
                Iterator<Object> i = dst.getChildren(dstPath);
                while (i.hasNext()) {
                    boolean remove;
                    next = i.next();
                    name = dst.getName(next);
                    a = this.getChild(srcPath, name);
                    if (a == null) {
                        remove = true;
                    } else {
                        switch (this.kind(a, dst, next)) {
                            default: {
                                remove = true;
                                break;
                            }
                            case 0: {
                                remove = !filter.acceptFile(a, name);
                                break;
                            }
                            case 3: {
                                boolean bl = remove = !filter.acceptDir(a, name);
                            }
                        }
                    }
                    if (remove) {
                        i.remove();
                        continue;
                    }
                    this.copy(a, filter, dst, next);
                }
                i = this.getChildren(srcPath);
                while (i.hasNext()) {
                    boolean dir;
                    boolean accept;
                    next = i.next();
                    name = this.getName(next);
                    a = dst.getChild(dstPath, name);
                    if (a != null || !(accept = (dir = this.isDir(next)) ? filter.acceptDir(next, name) : filter.acceptFile(next, name))) continue;
                    a = dst.makePath(dstPath, name);
                    this.copy(next, filter, dst, a);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Todo " + kind);
            }
        }
    }

    private <D> int kind(P srcPath, ReadWriteFileSystem<D> dst, D dstPath) throws IOException {
        if (this.isDir(srcPath)) {
            if (dst.isDir(dstPath)) {
                return 1;
            }
            if (dst.isFile(dstPath)) {
                return 2;
            }
            return 1;
        }
        if (this.isFile(srcPath)) {
            if (dst.isFile(dstPath)) {
                return 0;
            }
            if (dst.isDir(dstPath)) {
                return 3;
            }
            return 0;
        }
        return 4;
    }

    public final URL getURL() throws IOException {
        P root = this.getRoot();
        return this.getURL(root);
    }
}

