/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.Serializable;
import juzu.impl.metamodel.MetaModelObject;

public class MetaModelEvent
implements Serializable {
    public static final int AFTER_ADD = 0;
    public static final int BEFORE_REMOVE = 1;
    public static final int UPDATED = 2;
    private final int type;
    private final MetaModelObject object;
    private final Object payload;

    public static MetaModelEvent createAdded(MetaModelObject object, Object payload) {
        return new MetaModelEvent(0, object, payload);
    }

    public static MetaModelEvent createAdded(MetaModelObject object) {
        return new MetaModelEvent(0, object, null);
    }

    public static MetaModelEvent createUpdated(MetaModelObject object, Object payload) {
        return new MetaModelEvent(2, object, payload);
    }

    public static MetaModelEvent createUpdated(MetaModelObject object) {
        return new MetaModelEvent(2, object, null);
    }

    public static MetaModelEvent createRemoved(MetaModelObject object, Object payload) {
        return new MetaModelEvent(1, object, payload);
    }

    public static MetaModelEvent createRemoved(MetaModelObject object) {
        return new MetaModelEvent(1, object, null);
    }

    private MetaModelEvent(int type, MetaModelObject object, Object payload) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.object = object;
        this.payload = payload;
    }

    public int getType() {
        return this.type;
    }

    public MetaModelObject getObject() {
        return this.object;
    }

    public Object getPayload() {
        return this.payload;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MetaModelEvent) {
            MetaModelEvent that = (MetaModelEvent)obj;
            return this.type == that.type && this.object.equals(that.object);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.type + ",object=" + this.object.getClass().getSimpleName() + "]";
    }
}

