/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application.metamodel;

import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.Application;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.AnnotationChange;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.EventQueue;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelContext;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModelPlugin;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationModuleMetaModelPlugin
extends ModuleMetaModelPlugin {
    private static final Name APPLICATION = Name.create(Application.class);
    private static final String APPLICATION_DESCRIPTOR = ApplicationDescriptor.class.getSimpleName();
    final MetaModelContext<ApplicationMetaModelPlugin, ApplicationMetaModel> context = new MetaModelContext(ApplicationMetaModelPlugin.class);

    public ApplicationModuleMetaModelPlugin() {
        super("application");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        this.context.init(env);
        HashSet<Class<? extends Annotation>> annotationTypes = new HashSet<Class<? extends Annotation>>();
        annotationTypes.add(Application.class);
        annotationTypes.addAll(this.context.getSupportedAnnotations());
        return annotationTypes;
    }

    @Override
    public void postActivate(ModuleMetaModel metaModel) {
        for (ApplicationMetaModelPlugin plugin : this.context.getPlugins()) {
            plugin.postActivate(metaModel);
        }
        this.context.postActivate(metaModel.processingContext);
        for (ApplicationMetaModel application : metaModel.getChildren(ApplicationMetaModel.class)) {
            for (ApplicationMetaModelPlugin plugin : this.context.getPlugins()) {
                plugin.postActivate(application);
            }
        }
    }

    @Override
    public void processAnnotationChange(ModuleMetaModel metaModel, AnnotationChange change) {
        super.processAnnotationChange(metaModel, change);
        this.context.processAnnotationChange(change);
    }

    @Override
    public Iterable<? extends Completion> getCompletions(ModuleMetaModel metaModel, AnnotationKey annotationKey, AnnotationState annotationState, String member, String userText) {
        Iterable<Completion> completions = super.getCompletions(metaModel, annotationKey, annotationState, member, userText);
        if (completions == null) {
            completions = this.context.getCompletions(annotationKey, annotationState, member, userText);
        }
        return completions;
    }

    @Override
    public void processAnnotationAdded(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (key.getType().equals(APPLICATION)) {
            ElementHandle.Package pkg = (ElementHandle.Package)key.getElement();
            String name = (String)added.get("name");
            ApplicationMetaModel application = new ApplicationMetaModel(pkg, name);
            metaModel.addChild(Key.of(pkg, ApplicationMetaModel.class), application);
            this.context.add(application);
        }
    }

    @Override
    public void processAnnotationUpdated(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState removed, AnnotationState added) {
        if (key.getType().equals(APPLICATION)) {
            ElementHandle.Package pkg = (ElementHandle.Package)key.getElement();
            ApplicationMetaModel application = metaModel.getChild(Key.of(pkg, ApplicationMetaModel.class));
            application.modified = true;
        }
    }

    @Override
    public void processAnnotationRemoved(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        ElementHandle.Package pkg;
        ApplicationMetaModel mm;
        if (key.getType().equals(APPLICATION) && (mm = metaModel.getChild(Key.of(pkg = (ElementHandle.Package)key.getElement(), ApplicationMetaModel.class))) != null) {
            this.context.remove(mm);
            mm.remove();
        }
    }

    @Override
    public void postProcessAnnotations(ModuleMetaModel metaModel) {
        for (ApplicationMetaModel application : metaModel.getChildren(ApplicationMetaModel.class)) {
            if (!application.modified) continue;
            metaModel.queue(MetaModelEvent.createUpdated(application));
            application.modified = false;
        }
        this.context.postProcessAnnotations();
    }

    @Override
    public void processEvents(ModuleMetaModel metaModel, EventQueue queue) {
        while (queue.hasEvents()) {
            MetaModelEvent event = queue.popEvent();
            MetaModelObject obj = event.getObject();
            if (!(obj instanceof ApplicationMetaModel)) continue;
            ApplicationMetaModel application = (ApplicationMetaModel)obj;
            if (event.getType() != 0) continue;
            this.emitApplication(metaModel.processingContext, application);
        }
        this.context.processEvents();
    }

    void emitApplication(ProcessingContext env, ApplicationMetaModel application) throws ProcessingException {
        PackageElement elt = env.get(application.getHandle());
        Name fqn = application.getName().append("Application");
        Writer writer = null;
        try {
            try {
                JavaFileObject applicationFile = env.createSourceFile(fqn, elt);
                writer = applicationFile.openWriter();
                writer.append("package ").append(fqn.getParent()).append(";\n");
                writer.append("import ").append(ApplicationDescriptor.class.getCanonicalName()).append(";\n");
                writer.append("public class ").append(fqn.getIdentifier()).append(" {\n");
                writer.append("private final ").append(APPLICATION_DESCRIPTOR).append(" descriptor;\n");
                writer.append("public ").append(fqn.getIdentifier()).append("() throws Exception {\n");
                writer.append("this.descriptor = ").append(APPLICATION_DESCRIPTOR).append(".create(getClass());\n");
                writer.append("}\n");
                writer.append("public ").append(APPLICATION_DESCRIPTOR).append(" getDescriptor() {\n");
                writer.append("return descriptor;\n");
                writer.append("}\n");
                writer.append("}\n");
                env.log("Generated application " + fqn + " as " + applicationFile.toUri());
            }
            catch (IOException e) {
                throw TemplateMetaModel.CANNOT_WRITE_APPLICATION.failure(e, elt, application.getName());
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
    }

    @Override
    public void postProcessEvents(ModuleMetaModel metaModel) {
        this.context.postProcessEvents();
    }

    @Override
    public void prePassivate(ModuleMetaModel metaModel) {
        this.context.prePassivate();
        for (ApplicationMetaModelPlugin plugin : this.context.getPlugins()) {
            plugin.prePassivate(metaModel);
        }
        this.emitConfig(metaModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emitConfig(ModuleMetaModel metaModel) {
        Collection<ApplicationMetaModel> applications = metaModel.getChildren(ApplicationMetaModel.class);
        if (applications != null && applications.size() > 0) {
            for (ApplicationMetaModel application : applications) {
                Object var10_10;
                JSON descriptor = new JSON();
                metaModel.processingContext.log("Emitting application " + application.getHandle() + " config");
                for (ApplicationMetaModelPlugin plugin : this.context.getPlugins()) {
                    JSON pluginDescriptor = plugin.getDescriptor(application);
                    if (pluginDescriptor == null) continue;
                    descriptor.set(plugin.getName(), pluginDescriptor);
                }
                Writer writer = null;
                try {
                    try {
                        FileObject fo = metaModel.processingContext.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, application.getName(), "config.json", new Element[0]);
                        writer = fo.openWriter();
                        descriptor.toString(writer, 2);
                    }
                    catch (IOException e) {
                        throw ApplicationMetaModel.CANNOT_WRITE_APPLICATION_CONFIG.failure(e, metaModel.processingContext.get(application.getHandle()), application.getName());
                    }
                    var10_10 = null;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    Tools.safeClose(writer);
                    throw throwable;
                }
                Tools.safeClose(writer);
            }
        }
    }

    @Override
    public JSON getDescriptor(ModuleMetaModel metaModel) {
        JSON json = null;
        Collection<ApplicationMetaModel> applications = metaModel.getChildren(ApplicationMetaModel.class);
        if (applications != null && applications.size() > 0) {
            json = new JSON();
            for (ApplicationMetaModel application : applications) {
                json.set(application.getHandle().getPackageName().toString(), new JSON());
            }
        }
        return json;
    }
}

