/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

public class TrimmingException
extends Exception {
    private final String toString;
    private final Throwable source;

    public static void invoke(Callback callback) throws TrimmingException {
        try {
            callback.call();
        }
        catch (Throwable t) {
            throw new TrimmingException(t);
        }
    }

    private TrimmingException(Throwable t) {
        this(t, new Exception().getStackTrace().length);
    }

    private TrimmingException(Throwable t, int toTrim) {
        StackTraceElement[] trace = t.getStackTrace();
        StackTraceElement[] trimmed = new StackTraceElement[trace.length - toTrim];
        System.arraycopy(trace, 0, trimmed, 0, trimmed.length);
        this.setStackTrace(trimmed);
        this.toString = t.toString();
        this.source = t;
        Throwable cause = t.getCause();
        if (cause != null) {
            this.initCause(new TrimmingException(cause, toTrim));
        }
    }

    public Throwable getSource() {
        return this.source;
    }

    public String toString() {
        return this.toString;
    }

    public static interface Callback {
        public void call() throws Throwable;
    }
}

