/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import juzu.PropertyType;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.provided.ProvidedCDIInjector;
import juzu.impl.inject.spi.cdi.weld.WeldInjector;
import juzu.impl.inject.spi.guice.GuiceInjector;
import juzu.impl.inject.spi.spring.SpringInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InjectorProvider {
    CDI("cdi", 2){

        private Object getManager() {
            try {
                return new InitialContext().lookup("java:comp/BeanManager");
            }
            catch (NamingException notFound1) {
                try {
                    return new InitialContext().lookup("java:comp/env/BeanManager");
                }
                catch (NamingException notFound2) {
                    return null;
                }
            }
        }

        public Injector get() {
            return ProvidedCDIInjector.get(Thread.currentThread().getContextClassLoader());
        }

        public boolean isAvailable() {
            return this.getManager() != null;
        }
    }
    ,
    WELD("weld", 3){

        public Injector get() {
            return new WeldInjector();
        }

        public boolean isAvailable() {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.jboss.weld.bootstrap.WeldBootstrap");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    GUICE("guice", 0){

        public Injector get() {
            return new GuiceInjector();
        }

        public boolean isAvailable() {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("com.google.inject.Guice");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    SPRING("spring", 1){

        public Injector get() {
            return new SpringInjector();
        }

        public boolean isAvailable() {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.springframework.beans.factory.support.DefaultListableBeanFactory");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    };

    public static PropertyType<InjectorProvider> PROPERTY;
    final String value;
    final int priority;

    public abstract Injector get();

    private InjectorProvider(String value, int priority) {
        this.value = value;
        this.priority = priority;
    }

    public String getValue() {
        return this.value;
    }

    public int getPriority() {
        return this.priority;
    }

    public abstract boolean isAvailable();

    public static InjectorProvider find(String value) {
        if ("guice".equals(value)) {
            return GUICE;
        }
        if ("spring".equals(value)) {
            return SPRING;
        }
        if ("weld".equals(value)) {
            return WELD;
        }
        if ("cdi".equals(value)) {
            return CDI;
        }
        return null;
    }

    static {
        PROPERTY = new PropertyType<InjectorProvider>(){};
    }
}

