/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import juzu.impl.compiler.ElementHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationState
extends HashMap<String, Serializable> {
    private HashMap<String, Serializable> undeclared;

    public Serializable safeGet(String key) {
        Serializable value = (Serializable)this.get(key);
        if (value == null && this.undeclared != null) {
            value = this.undeclared.get(key);
        }
        return value;
    }

    public boolean isDeclared(String key) {
        return this.containsKey(key);
    }

    public boolean isUndeclared(String key) {
        return this.undeclared == null || this.undeclared.containsKey(key);
    }

    public static AnnotationState get(Element element, TypeMirror annotationType) throws NullPointerException {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().equals(annotationType)) continue;
            return AnnotationState.create(annotationMirror);
        }
        return null;
    }

    public static AnnotationState create(AnnotationMirror annotation) throws NullPointerException {
        if (annotation == null) {
            throw new NullPointerException("No null annotation allowed");
        }
        AnnotationState state = new AnnotationState();
        TypeElement annotationTypeElement = (TypeElement)annotation.getAnnotationType().asElement();
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (Element element : annotationTypeElement.getEnclosedElements()) {
            HashMap target;
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement xMember = (ExecutableElement)element;
            AnnotationValue value = values.get(xMember);
            String key = xMember.getSimpleName().toString();
            if (value == null) {
                if (state.undeclared == null) {
                    state.undeclared = new HashMap();
                }
                target = state.undeclared;
                value = xMember.getDefaultValue();
            } else {
                target = state;
            }
            if (value == null) continue;
            Serializable serialized = AnnotationState.unwrap(value, xMember.getReturnType());
            target.put(key, serialized);
        }
        return state;
    }

    private static Serializable unwrap(Object value, TypeMirror type) {
        if (value instanceof AnnotationValue) {
            value = ((AnnotationValue)value).getValue();
        }
        if (type instanceof ArrayType) {
            TypeMirror componentType = ((ArrayType)type).getComponentType();
            if (value instanceof List) {
                List array = (List)value;
                if (array.size() == 0) {
                    return (Serializable)((Object)Collections.emptyList());
                }
                ArrayList<Serializable> list = new ArrayList<Serializable>(array.size());
                for (Object element : array) {
                    list.add(AnnotationState.unwrap(element, componentType));
                }
                return list;
            }
            throw new UnsupportedOperationException("Impossible ? " + value + " " + value.getClass().getName());
        }
        if (value instanceof VariableElement) {
            return ((VariableElement)value).getSimpleName().toString();
        }
        if (value instanceof DeclaredType) {
            return ElementHandle.Type.create((TypeElement)((DeclaredType)value).asElement());
        }
        if (value instanceof AnnotationMirror) {
            return AnnotationState.create((AnnotationMirror)value);
        }
        if (value instanceof Serializable) {
            return (Serializable)value;
        }
        throw new UnsupportedOperationException("Need to unwrap not serializable type " + value + " " + value.getClass().getName());
    }
}

