/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.module;

import java.net.URL;
import java.util.HashMap;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import juzu.impl.common.JSON;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.module.ModuleContext;
import juzu.impl.plugin.module.ModulePlugin;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module {
    final AtomicInteger leases;
    public final ModuleContext context;
    private final HashMap<String, ModulePlugin> plugins;
    private final HashMap<String, PluginDescriptor> descriptors;

    public Module(final ModuleContext context) throws Exception {
        HashMap<String, ModulePlugin> plugins = new HashMap<String, ModulePlugin>();
        for (ModulePlugin plugin : ServiceLoader.load(ModulePlugin.class)) {
            plugins.put(plugin.getName(), plugin);
        }
        ResourceResolver classPathResolver = new ResourceResolver(){

            public URL resolve(String uri) {
                return context.getLifeCycle().getClassLoader().getResource(uri.substring(1));
            }
        };
        HashMap<String, PluginDescriptor> descriptors = new HashMap<String, PluginDescriptor>();
        for (ModulePlugin plugin : plugins.values()) {
            JSON pluginConfig;
            PluginContext pluginContext;
            PluginDescriptor desc = plugin.init(pluginContext = new PluginContext(pluginConfig = context.getConfig().getJSON(plugin.getName()), context, classPathResolver){
                final /* synthetic */ JSON val$pluginConfig;
                final /* synthetic */ ModuleContext val$context;
                final /* synthetic */ ResourceResolver val$classPathResolver;
                {
                    this.val$pluginConfig = jSON;
                    this.val$context = moduleContext;
                    this.val$classPathResolver = resourceResolver;
                }

                public JSON getConfig() {
                    return this.val$pluginConfig;
                }

                public ClassLoader getClassLoader() {
                    return this.val$context.getClassLoader();
                }

                public ResourceResolver getServerResolver() {
                    return this.val$context.getServerResolver();
                }

                public ResourceResolver getApplicationResolver() {
                    return this.val$classPathResolver;
                }
            });
            if (desc == null) continue;
            descriptors.put(plugin.getName(), desc);
        }
        this.plugins = plugins;
        this.descriptors = descriptors;
        this.context = context;
        this.leases = new AtomicInteger();
    }

    public ModulePlugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public <P extends ModulePlugin> P getPlugin(Class<P> type) {
        for (ModulePlugin plugin : this.plugins.values()) {
            if (!type.isInstance(plugin)) continue;
            return (P)((ModulePlugin)type.cast(plugin));
        }
        return null;
    }

    public synchronized void lease() {
        this.leases.incrementAndGet();
    }

    public synchronized boolean release() {
        return this.leases.decrementAndGet() == 0;
    }
}

