/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.xml.bind.DatatypeConverter;
import juzu.Method;
import juzu.asset.AssetLocation;
import juzu.bridge.vertx.Application;
import juzu.bridge.vertx.CookieScopeContext;
import juzu.bridge.vertx.VertxStream;
import juzu.bridge.vertx.VertxUserContext;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.bridge.spi.servlet.ServletScopedContext;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.common.Lexers;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.inject.Scoped;
import juzu.io.Stream;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.RequestParameter;
import juzu.request.UserContext;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertxWebBridge
extends WebBridge
implements HttpContext {
    private static final Pattern cookiePattern = Pattern.compile("([^=]+)=([^\\;]*);?\\s?");
    private static final ApplicationContext APPLICATION_CONTEXT = new ApplicationContext(){

        public ResourceBundle resolveBundle(Locale locale) {
            return null;
        }
    };
    private final Application application;
    private final Logger log;
    private ScopedContext requestScope;
    private final HttpServerRequest req;
    private Stream writer;
    private Map<String, RequestParameter> parameters;
    private Buffer buffer;
    private final Method method;
    private final Bridge bridge;
    CookieScopeContext[] cookieScopes;

    public VertxWebBridge(Bridge bridge, Application application, HttpServerRequest req, Buffer buffer, Logger log) {
        this.application = application;
        this.requestScope = null;
        this.req = req;
        this.writer = null;
        this.log = log;
        this.parameters = null;
        this.buffer = buffer;
        this.method = Method.valueOf((String)req.method);
        this.bridge = bridge;
        this.cookieScopes = new CookieScopeContext[2];
        String cookies = (String)req.headers().get("cookie");
        log.log((CharSequence)("Got cookies " + cookies));
        if (cookies != null) {
            ArrayList<HttpCookie> parsed = new ArrayList<HttpCookie>();
            Matcher matcher = cookiePattern.matcher(cookies);
            while (matcher.find()) {
                String cookieKey = matcher.group(1);
                String cookieValue = matcher.group(2);
                HttpCookie cookie = new HttpCookie(cookieKey, cookieValue);
                parsed.add(cookie);
            }
            for (HttpCookie cookie : parsed) {
                String prefix;
                int type;
                String name = cookie.getName();
                String value = cookie.getValue();
                if (name.startsWith("flash.")) {
                    type = 0;
                    prefix = "flash.";
                } else if (name.startsWith("session.")) {
                    type = 1;
                    prefix = "session.";
                } else {
                    type = -1;
                    prefix = null;
                }
                if (prefix == null) continue;
                try {
                    name = name.substring(prefix.length());
                    if (value.length() <= 0) continue;
                    CookieScopeContext context = this.getCookieScopeContext(type, true);
                    if (context.request == null) {
                        context.request = new HashMap();
                    }
                    context.request.put(name, value);
                }
                catch (Exception e) {
                    log.log((CharSequence)"Could not parse cookie", (Throwable)e);
                }
            }
        }
    }

    void handle(Handler handler) {
        try {
            handler.handle((WebBridge)this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.req.response.statusCode = 500;
            this.req.response.end();
            this.req.response.close();
        }
    }

    protected void end() {
        this.req.response.end();
        this.req.response.close();
    }

    public Map<String, RequestParameter> getParameters() {
        if (this.parameters == null) {
            if (this.req.query != null) {
                this.parameters = Lexers.parseQuery((String)this.req.query);
            } else {
                HashMap hashMap = this.parameters = this.buffer != null ? new HashMap() : Collections.emptyMap();
            }
            if (this.buffer != null) {
                Iterator i = Lexers.queryParser((CharSequence)this.buffer.toString());
                while (i.hasNext()) {
                    RequestParameter parameter = (RequestParameter)i.next();
                    parameter.appendTo(this.parameters);
                }
            }
        }
        return this.parameters;
    }

    public String getRequestURI() {
        return "/";
    }

    public String getPath() {
        return "/";
    }

    public String getRequestPath() {
        return this.req.path;
    }

    public void renderRequestURL(Appendable appendable) throws IOException {
        appendable.append("http://localhost:8080");
    }

    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
        switch (location) {
            case APPLICATION: {
                if (!uri.startsWith("/")) {
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("todo");
            }
        }
    }

    public ScopedContext getRequestScope(boolean create) {
        if (this.requestScope == null && create) {
            this.requestScope = new ServletScopedContext(this.log);
        }
        return this.requestScope;
    }

    CookieScopeContext getCookieScopeContext(int type, boolean create) {
        if (create && this.cookieScopes[type] == null) {
            this.cookieScopes[type] = new CookieScopeContext();
        }
        return this.cookieScopes[type];
    }

    public ScopedContext getFlashScope(boolean create) {
        return this.getCookieScopeContext(0, create);
    }

    public ScopedContext getSessionScope(boolean create) {
        return this.getCookieScopeContext(1, create);
    }

    public void purgeSession() {
        throw new UnsupportedOperationException("todo");
    }

    public HttpContext getHttpContext() {
        return this;
    }

    public ClientContext getClientContext() {
        throw new UnsupportedOperationException("todo");
    }

    public ApplicationContext getApplicationContext() {
        return APPLICATION_CONTEXT;
    }

    public void setContentType(String mimeType, Charset charset) {
        this.req.response.headers().put("Content-Type", "text/html; charset=UTF-8");
    }

    public void setStatus(int status) {
        this.req.response.statusCode = status;
    }

    public void setHeaders(Iterable<Map.Entry<String, String[]>> headers) {
        this.setHeaders("flash", this.cookieScopes[0]);
        this.setHeaders("session", this.cookieScopes[1]);
    }

    private void setHeaders(String scopeName, CookieScopeContext scope) {
        block4: {
            block5: {
                SimpleDateFormat expiresFormat = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'");
                String expires = expiresFormat.format(new Date(System.currentTimeMillis() + 3600000L));
                if (scope == null || scope.size() <= 0) break block4;
                if (!scope.purged) break block5;
                for (String name : scope.getNames()) {
                    this.log.log((CharSequence)("Clearing cookie " + name));
                    this.req.response.putHeader("Set-Cookie", (Object)(scopeName + "." + name + "=; Path=/"));
                }
                break block4;
            }
            if (scope.values == null) break block4;
            for (Map.Entry<String, Scoped> entry : scope.values.entrySet()) {
                String name = entry.getKey();
                Serializable value = (Serializable)entry.getValue().get();
                try {
                    String request;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Tools.serialize((Serializable)value, (OutputStream)baos);
                    baos.close();
                    String encoded = DatatypeConverter.printBase64Binary((byte[])baos.toByteArray());
                    String string = request = scope.request != null ? scope.request.get(name) : null;
                    if (encoded.equals(request)) continue;
                    this.log.log((CharSequence)("Sending cookie " + name + " = " + value + " as " + encoded));
                    this.req.response.putHeader("Set-Cookie", (Object)(scopeName + "." + name + "=" + encoded + "; Path=/"));
                }
                catch (Exception e) {
                    this.log.log((CharSequence)"Could not encode cookie", (Throwable)e);
                }
            }
        }
    }

    public void sendRedirect(String location) throws IOException {
        switch (this.method) {
            case GET: 
            case HEAD: {
                this.setStatus(302);
                break;
            }
            default: {
                this.setStatus(303);
            }
        }
        this.req.response.headers().put("Location", location);
        this.req.response.end();
        this.req.response.close();
    }

    public Stream getStream(Charset charset) throws IOException {
        if (this.writer == null) {
            this.writer = new VertxStream(charset, this.req.response);
        }
        return this.writer;
    }

    public UserContext getUserContext() {
        return VertxUserContext.INSTANCE;
    }

    public Method getMethod() {
        return this.method;
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "http";
    }

    public int getServerPort() {
        return this.application.port;
    }

    public String getServerName() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return "/";
    }
}

