/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.common.Logger;
import juzu.impl.inject.Scoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletScopedContext
implements ScopedContext,
HttpSessionBindingListener {
    private HashMap<Object, Scoped> state;
    private final Logger log;

    public ServletScopedContext(Logger log) {
        this.log = log;
    }

    @Override
    public Scoped get(Object key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null key accepted");
        }
        return this.state != null ? this.state.get(key) : null;
    }

    @Override
    public void set(Object key, Scoped scoped) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null key accepted");
        }
        if (scoped == null) {
            if (this.state != null) {
                this.state.remove(key);
            }
        } else {
            if (this.state == null) {
                this.state = new HashMap();
            }
            this.state.put(key, scoped);
        }
    }

    @Override
    public int size() {
        return this.state != null ? this.state.size() : 0;
    }

    @Override
    public Iterator<Scoped> iterator() {
        return this.state == null ? Collections.emptyList().iterator() : this.state.values().iterator();
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.close();
    }

    @Override
    public void close() {
        if (this.state != null && this.state.size() > 0) {
            Iterator<Scoped> i = this.state.values().iterator();
            while (i.hasNext()) {
                Scoped scoped = i.next();
                i.remove();
                try {
                    scoped.destroy();
                }
                catch (Throwable t) {
                    this.log.log("Error when destroying object", t);
                }
            }
        }
    }
}

