/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.Closeable;
import java.io.IOException;
import juzu.impl.common.CharBuffer;
import juzu.impl.common.Tools;
import juzu.io.Stream;
import juzu.io.Streamable;

public class AsyncStreamable
implements Streamable,
Appendable,
Closeable {
    private final CharBuffer buffer = new CharBuffer(512);
    private boolean closed = false;
    private Stream stream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Stream stream) throws IOException {
        CharBuffer charBuffer = this.buffer;
        synchronized (charBuffer) {
            if (this.stream != null) {
                throw new IllegalStateException("Already streaming");
            }
            this.stream = stream;
            this.buffer.writeTo(stream);
            if (this.closed) {
                Tools.safeClose(stream);
            }
        }
    }

    private Appendable delegate() {
        Stream s = this.stream;
        if (s != null) {
            return s;
        }
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncStreamable append(CharSequence csq) throws IOException {
        CharBuffer charBuffer = this.buffer;
        synchronized (charBuffer) {
            this.delegate().append(csq);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncStreamable append(CharSequence csq, int start, int end) throws IOException {
        CharBuffer charBuffer = this.buffer;
        synchronized (charBuffer) {
            this.delegate().append(csq, start, end);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncStreamable append(char c) throws IOException {
        CharBuffer charBuffer = this.buffer;
        synchronized (charBuffer) {
            this.delegate().append(c);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CharBuffer charBuffer = this.buffer;
        synchronized (charBuffer) {
            if (!this.closed && this.stream != null) {
                Tools.safeClose(this.stream);
            }
        }
    }
}

