/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.inject.Singleton;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Application {
    private final ApplicationDescriptor descriptor;
    final InjectionContext<?, ?> injectionContext;

    @Inject
    public Application(InjectionContext injectionContext, ApplicationDescriptor descriptor) throws Exception {
        this.injectionContext = injectionContext;
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public ClassLoader getClassLoader() {
        return this.injectionContext.getClassLoader();
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object resolveBean(String name) throws InvocationTargetException {
        return this.resolveBean(this.injectionContext, name);
    }

    private <B, I> Object resolveBean(InjectionContext<B, I> manager, String name) throws InvocationTargetException {
        B bean = manager.resolveBean(name);
        if (bean != null) {
            I cc = manager.create(bean);
            return manager.get(bean, cc);
        }
        return null;
    }
}

