/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.NoSuchElementException;

public class CharStream {
    private final CharSequence s;
    private int index;

    public CharStream(CharSequence s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("No null sequence accepted");
        }
        this.s = s;
        this.index = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void reset() {
        this.index = 0;
    }

    public boolean hasNext() {
        return this.has(0);
    }

    public boolean hasNext(char c) {
        return this.has(0, c);
    }

    public boolean has(int delta) {
        return this.index + delta < this.s.length();
    }

    public boolean has(int delta, char c) {
        int offset = this.index + delta;
        return offset < this.s.length() && this.s.charAt(offset) == c;
    }

    public boolean next(char c) {
        boolean a;
        boolean bl = a = this.index < this.s.length() && this.s.charAt(this.index) == c;
        if (a) {
            ++this.index;
        }
        return a;
    }

    public Character peek() {
        return this.peek(0);
    }

    public Character peek(int delta) {
        int offset = this.index + delta;
        if (offset < this.s.length()) {
            return Character.valueOf(this.s.charAt(offset));
        }
        return null;
    }

    public char next() throws NoSuchElementException {
        if (this.hasNext()) {
            return this.s.charAt(this.index++);
        }
        throw new NoSuchElementException();
    }
}

