/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.Serializable;
import juzu.impl.common.Lexers;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;

public abstract class Path
implements Serializable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final Name name;
    protected final String ext;
    private String canonical = null;

    public static Absolute absolute(Name name, String ext) {
        return new Absolute(name, ext);
    }

    public static Absolute absolute(Name qn, String rawName, String ext) {
        return new Absolute(qn, rawName, ext);
    }

    public static Relative relative(Name qn, String rawName, String ext) {
        return new Relative(qn, rawName, ext);
    }

    public static Relative relative(Name name, String ext) {
        return new Relative(name, ext);
    }

    public static Path create(boolean absolute, Name qn, String rawName, String ext) {
        if (absolute) {
            return Path.absolute(qn, rawName, ext);
        }
        return Path.relative(qn, rawName, ext);
    }

    public static Path parse(String path) throws NullPointerException, IllegalArgumentException {
        boolean absolute = path.length() > 0 && path.charAt(0) == '/';
        String[] atoms = Lexers.parsePath(0, EMPTY_STRING_ARRAY, 0, path, 0);
        if (absolute) {
            return new Absolute(new Name(atoms, atoms.length - 1), atoms[atoms.length - 1]);
        }
        return new Relative(new Name(atoms, atoms.length - 1), atoms[atoms.length - 1]);
    }

    private Path(Name pkg, String rawName, String ext) {
        this.name = pkg.append(rawName);
        this.ext = ext;
    }

    private Path(Name name, String ext) {
        this.name = name;
        this.ext = ext;
    }

    public Path append(String path) throws NullPointerException, IllegalArgumentException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            throw new IllegalArgumentException("Cannot append absolute path " + path);
        }
        String[] atoms = Lexers.parsePath(1, this.name.identifiers, this.name.size - 1, path, 0);
        return this.create(new Name(atoms, atoms.length - 1), atoms[atoms.length - 1]);
    }

    public String getValue() {
        return this.getCanonical();
    }

    protected abstract Path create(Name var1, String var2);

    public final boolean isAbsolute() {
        return this instanceof Absolute;
    }

    public final boolean isRelative() {
        return !this.isAbsolute();
    }

    public Name getDirs() {
        return this.name.getParent();
    }

    public Name getName() {
        return this.name;
    }

    public String getRawName() {
        return this.name.getIdentifier();
    }

    public String getExt() {
        return this.ext;
    }

    public String getSimpleName() {
        String ext = this.getExt();
        String rawName = this.getRawName();
        if (ext != null) {
            return rawName + "." + ext;
        }
        return rawName;
    }

    public Path as(String ext) {
        return this.create(this.name, ext);
    }

    public Path as(String rawName, String ext) {
        String[] tmp = new String[this.name.size];
        System.arraycopy(this.name.identifiers, 0, tmp, 0, this.name.size - 1);
        tmp[tmp.length - 1] = rawName;
        return this.create(new Name(tmp, tmp.length), ext);
    }

    public String getCanonical() {
        if (this.canonical == null) {
            StringBuilder sb = new StringBuilder();
            if (this.isAbsolute()) {
                sb.append('/');
            }
            for (int i = 0; i < this.name.size(); ++i) {
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(this.name.get(i));
            }
            String ext = this.getExt();
            if (ext != null) {
                sb.append('.').append(ext);
            }
            this.canonical = sb.toString();
        }
        return this.canonical;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Path that = (Path)obj;
            return this.isAbsolute() == that.isAbsolute() && this.name.equals(that.name) && Tools.safeEquals(this.ext, that.ext);
        }
        return false;
    }

    public String toString() {
        return "Path[" + this.getCanonical() + "]";
    }

    public static class Relative
    extends Path {
        public Relative(Name pkg, String rawName, String ext) {
            super(pkg, rawName, ext);
        }

        public Relative(Name name, String ext) {
            super(name, ext);
        }

        protected Relative create(Name name, String ext) {
            return new Relative(name, ext);
        }

        public Relative as(String ext) {
            return (Relative)super.as(ext);
        }

        public Relative as(String rawName, String ext) {
            return (Relative)super.as(rawName, ext);
        }
    }

    public static class Absolute
    extends Path {
        public Absolute(Name pkg, String rawName, String ext) {
            super(pkg, rawName, ext);
        }

        public Absolute(Name name, String ext) {
            super(name, ext);
        }

        protected Absolute create(Name name, String ext) {
            return new Absolute(name, ext);
        }

        public Absolute as(String ext) {
            return (Absolute)super.as(ext);
        }

        public Absolute as(String rawName, String ext) {
            return (Absolute)super.as(rawName, ext);
        }
    }
}

