/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import juzu.Method;
import juzu.asset.AssetLocation;
import juzu.bridge.vertx.CookieScopeContext;
import juzu.bridge.vertx.VertxStream;
import juzu.impl.bridge.spi.web.HttpStream;
import juzu.impl.bridge.spi.web.WebRequestContext;
import juzu.impl.common.Lexers;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.inject.Scoped;
import juzu.io.Stream;
import juzu.request.RequestParameter;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertxRequestContext
extends WebRequestContext {
    private static final Pattern cookiePattern = Pattern.compile("([^=]+)=([^\\;]*);?\\s?");
    final HttpServerRequest req;
    private Map<String, RequestParameter> parameters;
    private final String requestPath;
    private final String query;
    private Buffer buffer;
    final Method method;
    private HttpStream writer;
    final Logger log;
    CookieScopeContext[] cookieScopes;

    public VertxRequestContext(HttpServerRequest req, Buffer buffer, Logger log) {
        String query;
        String requestPath;
        String uri = req.uri;
        int index = uri.indexOf(63);
        if (index == -1) {
            requestPath = uri;
            query = null;
        } else {
            requestPath = uri.substring(0, index);
            query = uri.substring(index + 1);
        }
        this.cookieScopes = new CookieScopeContext[2];
        this.method = Method.valueOf((String)req.method);
        this.requestPath = requestPath;
        this.query = query;
        this.req = req;
        this.parameters = null;
        this.buffer = buffer;
        this.log = log;
        String cookies = (String)req.headers().get("cookie");
        log.info((CharSequence)("Got cookies " + cookies));
        if (cookies != null) {
            ArrayList<HttpCookie> parsed = new ArrayList<HttpCookie>();
            Matcher matcher = cookiePattern.matcher(cookies);
            while (matcher.find()) {
                String cookieKey = matcher.group(1);
                String cookieValue = matcher.group(2);
                HttpCookie cookie = new HttpCookie(cookieKey, cookieValue);
                parsed.add(cookie);
            }
            for (HttpCookie cookie : parsed) {
                String prefix;
                int type;
                String name = cookie.getName();
                String value = cookie.getValue();
                if (name.startsWith("flash.")) {
                    type = 0;
                    prefix = "flash.";
                } else if (name.startsWith("session.")) {
                    type = 1;
                    prefix = "session.";
                } else {
                    type = -1;
                    prefix = null;
                }
                if (prefix == null) continue;
                try {
                    name = name.substring(prefix.length());
                    if (value.length() <= 0) continue;
                    CookieScopeContext context = this.getCookieScopeContext(type, true);
                    if (context.snapshot == null) {
                        context.snapshot = new HashMap();
                    }
                    context.snapshot.put(name, value);
                }
                catch (Exception e) {
                    log.info((CharSequence)"Could not parse cookie", (Throwable)e);
                }
            }
        }
    }

    CookieScopeContext getCookieScopeContext(int type, boolean create) {
        if (create && this.cookieScopes[type] == null) {
            this.cookieScopes[type] = new CookieScopeContext();
        }
        return this.cookieScopes[type];
    }

    public Map<String, RequestParameter> getParameters() {
        if (this.parameters == null) {
            if (this.query != null) {
                this.parameters = Lexers.parseQuery((String)this.query);
            } else {
                HashMap hashMap = this.parameters = this.buffer != null ? new HashMap() : Collections.emptyMap();
            }
            if (this.buffer != null) {
                Iterator i = Lexers.queryParser((CharSequence)this.buffer.toString());
                while (i.hasNext()) {
                    RequestParameter parameter = (RequestParameter)i.next();
                    parameter.appendTo(this.parameters);
                }
            }
        }
        return this.parameters;
    }

    public String getRequestURI() {
        return "/";
    }

    public String getPath() {
        return "/";
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
        switch (location) {
            case APPLICATION: {
                if (!uri.startsWith("/")) {
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("todo");
            }
        }
    }

    public void setContentType(String mimeType, Charset charset) {
        this.req.response.headers().put("Content-Type", "text/html; charset=UTF-8");
    }

    public void setStatus(int status) {
        this.req.response.statusCode = status;
    }

    public void setHeaders(Iterable<Map.Entry<String, String[]>> headers) {
        LinkedList<String> cookies = new LinkedList<String>();
        this.setHeaders("flash", this.cookieScopes[0], cookies);
        this.setHeaders("session", this.cookieScopes[1], cookies);
        if (cookies.size() > 0) {
            this.req.response.putHeader("Set-Cookie", cookies);
        }
    }

    private void setHeaders(String scopeName, CookieScopeContext scope, LinkedList<String> cookies) {
        block4: {
            block5: {
                SimpleDateFormat expiresFormat = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'");
                String expires = expiresFormat.format(new Date(System.currentTimeMillis() + 3600000L));
                if (scope == null || scope.size() <= 0) break block4;
                if (!scope.purged) break block5;
                for (String name : scope.getNames()) {
                    this.log.info((CharSequence)("Clearing cookie " + name));
                    cookies.add(scopeName + "." + name + "=; Path=/");
                }
                break block4;
            }
            if (scope.values == null) break block4;
            for (Map.Entry<String, Scoped> entry : scope.values.entrySet()) {
                String name = entry.getKey();
                Serializable value = (Serializable)entry.getValue().get();
                try {
                    String request;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Tools.serialize((Serializable)value, (OutputStream)baos);
                    baos.close();
                    String encoded = DatatypeConverter.printBase64Binary((byte[])baos.toByteArray());
                    String string = request = scope.snapshot != null ? scope.snapshot.get(name) : null;
                    if (encoded.equals(request)) continue;
                    this.log.info((CharSequence)("Sending cookie " + name + " = " + value + " as " + encoded));
                    cookies.add(scopeName + "." + name + "=" + encoded + "; Path=/");
                }
                catch (Exception e) {
                    this.log.info((CharSequence)"Could not encode cookie", (Throwable)e);
                }
            }
        }
    }

    public void sendRedirect(String location) throws IOException {
        switch (this.method) {
            case GET: 
            case HEAD: {
                this.setStatus(302);
                break;
            }
            default: {
                this.setStatus(303);
            }
        }
        this.req.response.headers().put("Location", location);
        this.req.response.end();
        this.req.response.close();
    }

    public HttpStream getStream(int status) {
        if (this.writer == null) {
            this.writer = new HttpStream(this, status, Tools.UTF_8){
                private VertxStream stream;

                public void setStatusCode(int status) {
                    VertxRequestContext.this.setStatus(status);
                }

                protected Stream getDataStream(boolean create) {
                    if (this.stream == null && create) {
                        this.stream = new VertxStream(this.encoding, VertxRequestContext.this.req.response);
                    }
                    return this.stream;
                }

                protected void endAsync() {
                    VertxRequestContext.this.req.response.end();
                    VertxRequestContext.this.req.response.close();
                }

                protected void beginAsync() {
                }
            };
        }
        return this.writer;
    }
}

