/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.module;

import java.net.URL;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.plugin.module.ModuleContext;
import juzu.impl.resource.ResourceResolver;
import juzu.impl.runtime.ModuleRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleContextImpl
implements ModuleContext {
    final BridgeContext bridgeContext;
    final ResourceResolver resolver;
    final ModuleRuntime<?> runtime;
    final RunMode runMode;

    public ModuleContextImpl(Logger log, BridgeContext bridgeContext, ResourceResolver resolver) {
        ModuleRuntime lifeCycle;
        RunMode runMode;
        String runModeValue = bridgeContext.getInitParameter("juzu.run_mode");
        if (runModeValue != null) {
            runMode = RunMode.parse(runModeValue = Tools.interpolate(runModeValue, System.getProperties()));
            if (runMode == null) {
                log.info("Unparseable run mode " + runModeValue + " will use prod instead");
                runMode = RunMode.PROD;
            }
        } else {
            runMode = RunMode.PROD;
        }
        if (runMode.isDynamic()) {
            ReadFileSystem<?> sourcePath = bridgeContext.getSourcePath();
            log.info("Initializing live module at " + sourcePath.getDescription());
            lifeCycle = new ModuleRuntime.Dynamic(log, Thread.currentThread().getContextClassLoader(), sourcePath);
        } else {
            log.info("Initializing module in " + runMode.name().toLowerCase() + " mode");
            ReadFileSystem<?> classPath = bridgeContext.getClassPath();
            lifeCycle = new ModuleRuntime.Static(log, Thread.currentThread().getContextClassLoader(), classPath);
        }
        this.bridgeContext = bridgeContext;
        this.resolver = resolver;
        this.runtime = lifeCycle;
        this.runMode = runMode;
    }

    @Override
    public JSON getConfig() throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        URL cfg = classLoader.getResource("juzu/config.json");
        String s = Tools.read(cfg);
        return (JSON)JSON.parse(s);
    }

    @Override
    public ReadFileSystem<?> getResourcePath() {
        return this.bridgeContext.getResourcePath();
    }

    @Override
    public RunMode getRunMode() {
        return this.runMode;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.runtime.getClassLoader();
    }

    @Override
    public ResourceResolver getServerResolver() {
        return this.resolver;
    }
}

