/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.module;

import java.util.concurrent.atomic.AtomicReference;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.bridge.module.ModuleContextImpl;
import juzu.impl.common.Completion;
import juzu.impl.common.Logger;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.Injector;
import juzu.impl.plugin.application.Application;
import juzu.impl.resource.ResourceResolver;
import juzu.impl.runtime.ApplicationRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationBridge
extends Bridge {
    private final ModuleContextImpl module;
    private final AtomicReference<ApplicationRuntime<?, ?>> application;
    private final Injector injector;
    private final Logger log;

    public ApplicationBridge(ModuleContextImpl moduleContext, BridgeContext context, BridgeConfig config, AssetServer server, ResourceResolver resolver, Injector injector) {
        super(context, config, server, resolver);
        this.module = moduleContext;
        this.log = context.getLogger(ApplicationBridge.class.getName());
        this.injector = injector;
        this.application = new AtomicReference();
    }

    @Override
    public RunMode getRunMode() {
        return this.module.getRunMode();
    }

    @Override
    public Completion<Boolean> refresh(boolean recompile) {
        Completion<Boolean> refresh = this.module.runtime.refresh(recompile);
        if (refresh.isFailed()) {
            return refresh;
        }
        while (this.application.get() == null) {
            this.application.compareAndSet(null, new ApplicationRuntime(this.log, this.module.runtime, this.injector, this.config.name, this.server, this.resolver));
        }
        return this.application.get().refresh();
    }

    @Override
    public Application getApplication() {
        return this.application.get().getApplication();
    }

    @Override
    public void close() {
        ApplicationRuntime runtime = this.application.getAndSet(null);
        if (runtime != null) {
            Tools.safeClose(runtime);
        }
    }
}

