/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import juzu.impl.common.FileKey;
import juzu.impl.common.Resource;
import juzu.impl.common.Timestamped;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileObjectImpl<P>
implements JavaFileObject {
    final FileKey key;
    final ReadFileSystem<P> fs;
    private final P file;
    Timestamped<Resource> content;
    private boolean writing;
    final URI uri;

    public JavaFileObjectImpl(JavaFileManager.Location location, FileKey key, ReadFileSystem<P> fs, P file) throws NullPointerException, IOException {
        URI uri;
        if (file == null) {
            throw new NullPointerException("No null file accepted for " + key);
        }
        try {
            uri = fs.getURL(file).toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not create uri for file " + file, e);
        }
        this.key = key;
        this.fs = fs;
        this.file = file;
        this.writing = false;
        this.uri = uri;
    }

    public FileKey getKey() {
        return this.key;
    }

    private Timestamped<Resource> assertContent() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.content == null) {
            this.content = this.fs.getResource(this.file);
            if (this.content == null) {
                throw new FileNotFoundException("File " + this.key + " cannot be found");
            }
        }
        return this.content;
    }

    public File getFile() throws IOException {
        return this.fs.getFile(this.file);
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        String baseName = simpleName + kind.extension;
        return kind.equals((Object)this.getKind()) && (baseName.equals(this.toUri().getPath()) || this.toUri().getPath().endsWith("/" + baseName));
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.key.getKind();
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        CharSequence charContent = this.getCharContent(ignoreEncodingErrors);
        if (charContent == null) {
            throw new IOException("No content");
        }
        return new StringReader(charContent.toString());
    }

    @Override
    public boolean delete() {
        if (this.fs instanceof ReadWriteFileSystem) {
            try {
                return ((ReadWriteFileSystem)this.fs).removePath(this.file);
            }
            catch (IOException ignore) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        File f = this.fs.getFile(this.file);
        if (f != null) {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.key.rawName;
    }

    public String toString() {
        return this.key.rawName;
    }

    @Override
    public long getLastModified() {
        try {
            return this.assertContent().getTime();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public final CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.assertContent().getObject().getCharSequence();
    }

    @Override
    public final InputStream openInputStream() throws IOException {
        return this.assertContent().getObject().getInputStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.fs instanceof ReadWriteFileSystem) {
            final ReadWriteFileSystem fs = (ReadWriteFileSystem)this.fs;
            return new ByteArrayOutputStream(){

                public void close() throws IOException {
                    Resource content = new Resource(this.toByteArray(), null);
                    long lastModified = fs.updateResource(JavaFileObjectImpl.this.file, content);
                    JavaFileObjectImpl.this.content = new Timestamped<Resource>(lastModified, content);
                    JavaFileObjectImpl.this.writing = false;
                }
            };
        }
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public Writer openWriter() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.fs instanceof ReadWriteFileSystem) {
            final ReadWriteFileSystem fs = (ReadWriteFileSystem)this.fs;
            return new StringWriter(){

                public void close() throws IOException {
                    Resource content = new Resource(this.getBuffer());
                    long lastModified = fs.updateResource(JavaFileObjectImpl.this.file, content);
                    JavaFileObjectImpl.this.content = new Timestamped<Resource>(lastModified, content);
                    JavaFileObjectImpl.this.writing = false;
                }
            };
        }
        throw new UnsupportedOperationException("Read only");
    }
}

