/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.bridge.spi.web.AsyncStream;
import juzu.impl.bridge.spi.web.HttpStream;
import juzu.impl.bridge.spi.web.WebStream;
import juzu.impl.compiler.CompilationException;
import juzu.impl.io.SafeStream;
import juzu.impl.plugin.asset.AssetPlugin;
import juzu.request.RequestParameter;
import juzu.request.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebRequestContext {
    public final void send(CompilationException e) throws IOException {
        this.send(e.result(), true);
    }

    public final void send(Result.Error error, boolean verbose) throws IOException {
        this.send(null, error.asStatus(verbose));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(AssetPlugin assetPlugin, Result.Status response) throws IOException {
        AsyncStream stream = this.getStream(response.code);
        if (response.decorated) {
            AssetManager assetManager = assetPlugin != null ? assetPlugin.getAssetManager() : null;
            stream = new WebStream((HttpStream)stream, assetManager){

                public String renderAssetURL(AssetLocation location, String uri) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        WebRequestContext.this.renderAssetURL(location, uri, sb);
                        return sb.toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new UnsupportedOperationException("handle me ", e);
                    }
                }
            };
        }
        try {
            response.streamable.send(new SafeStream(stream));
        }
        finally {
            stream.end();
        }
    }

    public abstract Map<String, RequestParameter> getParameters();

    public abstract String getRequestURI();

    public abstract String getPath();

    public abstract String getRequestPath();

    public abstract void setContentType(String var1, Charset var2);

    public abstract void setStatus(int var1);

    public abstract void setHeaders(Iterable<Map.Entry<String, String[]>> var1);

    public abstract void sendRedirect(String var1) throws IOException;

    public abstract HttpStream getStream(int var1);

    public abstract void renderAssetURL(AssetLocation var1, String var2, Appendable var3) throws IOException;
}

