/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.asset.Asset;
import juzu.impl.plugin.asset.AssetsMetaModel;
import juzu.plugin.asset.Assets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode ASSET_NOT_FOUND = new MessageCode("ASSET_NOT_FOUND", "The asset %1$s cannot be resolved");

    public AssetMetaModelPlugin() {
        super("asset");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Assets.class);
    }

    @Override
    public void init(ApplicationMetaModel metaModel) {
        metaModel.addChild(AssetsMetaModel.KEY, new AssetsMetaModel());
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (metaModel.getHandle().equals(key.getElement())) {
            AssetsMetaModel assetsMetaModel = metaModel.getChild(AssetsMetaModel.KEY);
            for (Asset asset : this.getAssets(added)) {
                assetsMetaModel.addAsset(asset);
            }
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (metaModel.getHandle().equals(key.getElement())) {
            AssetsMetaModel assetsMetaModel = metaModel.getChild(AssetsMetaModel.KEY);
            for (Asset asset : this.getAssets(removed)) {
                assetsMetaModel.removeAsset(asset);
            }
        }
    }

    private Iterable<Asset> getAssets(AnnotationState annotation) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        String location = (String)annotation.get("location");
        if (location == null) {
            location = AssetLocation.APPLICATION.name();
        }
        List value = (List)annotation.get("value");
        for (AnnotationState asset : value) {
            String type;
            String v;
            HashMap<String, Serializable> state = new HashMap<String, Serializable>(asset);
            if (state.get("location") == null) {
                state.put("location", (Serializable)((Object)location));
            }
            if (state.get("id") == null) {
                state.put("id", (Serializable)state.get("value"));
            }
            if ((v = (String)state.get("value")).endsWith(".js")) {
                type = "script";
            } else if (v.endsWith(".css")) {
                type = "stylesheet";
            } else if (v.endsWith(".less")) {
                type = "stylesheet";
            } else {
                throw new UnsupportedOperationException("Handle me gracefully " + v);
            }
            assets.add(new Asset(type, state));
        }
        return assets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prePassivate(ApplicationMetaModel metaModel) {
        ProcessingContext context = metaModel.getProcessingContext();
        Name qn = metaModel.getHandle().getPackageName().append("assets");
        if (!context.isCopyFromSourcesExternallyManaged()) {
            AssetsMetaModel annotation = metaModel.getChild(AssetsMetaModel.KEY);
            HashMap<String, URL> bilta = new HashMap<String, URL>();
            HashMap<String, Asset> bilto = new HashMap<String, Asset>();
            for (Asset asset : annotation.getAssets()) {
                if (asset.key.location != AssetLocation.APPLICATION || asset.key.value.startsWith("/")) continue;
                bilto.put(asset.key.value, asset);
                URL resource = annotation.getResources().get(asset.key.value);
                if (resource == null) {
                    resource = annotation.resolveResource(asset.key.value);
                }
                if (resource != null) {
                    bilta.put(asset.key.value, resource);
                    continue;
                }
                throw ASSET_NOT_FOUND.failure(asset.key.value);
            }
            bilta.putAll(annotation.getResources());
            for (Map.Entry entry : bilta.entrySet()) {
                OutputStream out;
                InputStream in;
                block11: {
                    in = null;
                    out = null;
                    try {
                        URL src = (URL)entry.getValue();
                        URLConnection conn = src.openConnection();
                        FileObject dst = context.getResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, qn, (CharSequence)entry.getKey());
                        if (dst == null || dst.getLastModified() < conn.getLastModified()) {
                            in = conn.getInputStream();
                            dst = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, qn, (CharSequence)entry.getKey(), context.get(metaModel.getHandle()));
                            context.info("Copying asset from source path " + src + " to class output " + dst.toUri());
                            Asset r = (Asset)bilto.remove(entry.getKey());
                            if (r != null) {
                                in = r.filter(in);
                            }
                            out = dst.openOutputStream();
                            Tools.copy(in, out);
                            break block11;
                        }
                        context.info("Found up to date related asset in class output for " + src);
                    }
                    catch (IOException e) {
                        try {
                            context.info("Could not copy asset " + (String)entry.getKey() + " ", e);
                        }
                        catch (Throwable throwable) {
                            Tools.safeClose(in);
                            Tools.safeClose(out);
                            throw throwable;
                        }
                        Tools.safeClose(in);
                        Tools.safeClose(out);
                        continue;
                    }
                }
                Tools.safeClose(in);
                Tools.safeClose(out);
            }
        }
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        AssetsMetaModel assetsMetaModel = application.getChild(AssetsMetaModel.KEY);
        Iterator<Asset> assets = assetsMetaModel.getAssets().iterator();
        if (assets.hasNext()) {
            JSON json = new JSON();
            ArrayList<JSON> list = new ArrayList<JSON>();
            while (assets.hasNext()) {
                list.add(assets.next().getJSON());
            }
            json.set("assets", list);
            json.set("package", "assets");
            return json;
        }
        return null;
    }
}

