/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import juzu.bridge.vertx.Application;
import juzu.impl.common.Name;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import org.vertx.java.busmods.BusModBase;
import org.vertx.java.core.json.JsonObject;

public class JuzuBusMod
extends BusModBase {
    private Application application;

    public void start() {
        try {
            this._start();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void _start() throws Exception {
        JsonObject config = this.container.getConfig();
        String main = config.getString("main");
        if (main == null) {
            throw new Exception("No application main specified");
        }
        Integer port = config.getInteger("port");
        if (port == null) {
            port = 8080;
        }
        Name mainName = Name.parse((CharSequence)main);
        Name infoName = mainName.append(new String[]{"package-info"});
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL infoURL = loader.getResource(infoName.toString().replace('.', '/') + ".java");
        if (infoURL == null) {
            throw new Exception("No application found at " + infoName);
        }
        File root = new File(infoURL.toURI()).getParentFile();
        for (int i = 0; i < mainName.size(); ++i) {
            root = root.getParentFile();
        }
        DiskFileSystem sourcePath = new DiskFileSystem(root);
        this.application = new Application(this.container, this.vertx, loader, sourcePath, mainName, port);
        this.application.start();
    }

    public void stop() throws Exception {
        if (this.application != null) {
            this.application.stop();
        }
    }
}

