/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.parser;

import japa.parser.ast.Node;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.visitor.GenericVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb.annox.annotation.NoSuchAnnotationFieldException;
import org.jvnet.jaxb.annox.model.annotation.field.XAnnotationField;
import org.jvnet.jaxb.annox.model.annotation.field.XArrayAnnotationField;
import org.jvnet.jaxb.annox.model.annotation.value.XAnnotationValue;
import org.jvnet.jaxb.annox.parser.XAnnotationFieldParser;
import org.jvnet.jaxb.annox.parser.exception.AnnotationElementParseException;
import org.jvnet.jaxb.annox.parser.exception.AnnotationExpressionParseException;
import org.jvnet.jaxb.annox.parser.exception.ValueParseException;
import org.jvnet.jaxb.annox.parser.java.visitor.ExpressionVisitor;
import org.jvnet.jaxb.annox.parser.value.XAnnotationValueParser;
import org.jvnet.jaxb.annox.util.AnnotationElementUtils;
import org.w3c.dom.Element;

public class XArrayAnnotationFieldParser<T, V>
extends XAnnotationFieldParser<T[], V[]> {
    private final XAnnotationValueParser<T, V> annotationValueParser;

    public XArrayAnnotationFieldParser(XAnnotationValueParser<T, V> annotationValueParser) {
        this.annotationValueParser = (XAnnotationValueParser)Validate.notNull(annotationValueParser);
    }

    @Override
    public XAnnotationField<T[]> parse(Element element, String name, Class<?> type) throws AnnotationElementParseException {
        Class<?> componentType = type.getComponentType();
        String[] draft = AnnotationElementUtils.getFieldValues(element, name);
        try {
            XAnnotationValue[] fieldValues = new XAnnotationValue[draft.length];
            for (int index = 0; index < draft.length; ++index) {
                fieldValues[index] = this.annotationValueParser.parse(draft[index], componentType);
            }
            return new XArrayAnnotationField(name, type, fieldValues);
        }
        catch (ValueParseException vpex) {
            throw new AnnotationElementParseException(element, (Throwable)vpex);
        }
    }

    @Override
    public XAnnotationField<T[]> construct(String name, V[] value, Class<?> type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException(MessageFormat.format("Type [{0}] is expected to be an array type.", type));
        }
        Class<?> componentType = type.getComponentType();
        XAnnotationValue[] fieldValues = new XAnnotationValue[value.length];
        for (int index = 0; index < value.length; ++index) {
            V item = value[index];
            fieldValues[index] = this.annotationValueParser.construct(item, componentType);
        }
        XArrayAnnotationField annotationField = new XArrayAnnotationField(name, type, fieldValues);
        return annotationField;
    }

    @Override
    public XAnnotationField<T[]> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
        Object values = this.getAnnotationFieldValue(annotation, name);
        int length = Array.getLength(values);
        Object[] value = (Object[])Array.newInstance(ClassUtils.primitiveToWrapper(type.getComponentType()), length);
        for (int index = 0; index < length; ++index) {
            Object object;
            value[index] = object = Array.get(values, index);
        }
        return this.construct(name, value, type);
    }

    @Override
    public XAnnotationField<T[]> parse(Expression expression, final String name, final Class<?> type) throws AnnotationExpressionParseException {
        final ExpressionVisitor<XAnnotationValue<T>> expressionVisitor = this.annotationValueParser.createExpressionVisitor(type.getComponentType());
        try {
            return (XAnnotationField)expression.accept((GenericVisitor)new ExpressionVisitor<XAnnotationField<T[]>>(type){

                @Override
                public XAnnotationField<T[]> visitDefault(Expression n, Void arg) {
                    XAnnotationValue v = (XAnnotationValue)n.accept((GenericVisitor)expressionVisitor, null);
                    XArrayAnnotationField arrayAnnotationField = new XArrayAnnotationField(name, type, v);
                    return arrayAnnotationField;
                }

                @Override
                public XAnnotationField<T[]> visit(ArrayInitializerExpr n, Void arg) {
                    List expressions = n.getValues();
                    XAnnotationValue[] values = new XAnnotationValue[expressions.size()];
                    for (int index = 0; index < expressions.size(); ++index) {
                        XAnnotationValue v;
                        values[index] = v = (XAnnotationValue)((Expression)expressions.get(index)).accept((GenericVisitor)expressionVisitor, null);
                    }
                    XArrayAnnotationField arrayAnnotationField = new XArrayAnnotationField(name, type, values);
                    return arrayAnnotationField;
                }
            }, null);
        }
        catch (RuntimeException rex) {
            if (rex.getCause() != null) {
                throw new AnnotationExpressionParseException((Node)expression, rex.getCause());
            }
            throw new AnnotationExpressionParseException((Node)expression, (Throwable)rex);
        }
    }
}

