/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.propertylistenerinjector;

import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.util.DOMUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.jvnet.jaxb2_commons.plugin.propertylistenerinjector.Customizations;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class PropertyListenerInjectorPlugin
extends Plugin {
    protected final String OPTION_NAME = "Xinject-listener-code";

    public String getOptionName() {
        return "Xinject-listener-code";
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(Customizations.NAMESPACE_URI);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals(Customizations.LISTENER_ELEMENT_NAME.getNamespaceURI()) && localName.equals(Customizations.LISTENER_ELEMENT_NAME.getLocalPart());
    }

    public String getUsage() {
        return "  -XXinject-listener-code\t:  inject property change event support to setter methods";
    }

    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        CPluginCustomization listener = model.getModel().getCustomizations().find(Customizations.NAMESPACE_URI, Customizations.LISTENER_ELEMENT_NAME.getLocalPart());
        String globalInterfaceSetting = VetoableChangeListener.class.getName();
        if (listener != null) {
            listener.markAsAcknowledged();
            globalInterfaceSetting = DOMUtils.getElementText((Element)listener.element);
        }
        for (ClassOutline co : model.getClasses()) {
            String interfaceName;
            CPluginCustomization c = co.target.getCustomizations().find(Customizations.NAMESPACE_URI, Customizations.LISTENER_ELEMENT_NAME.getLocalPart());
            if (c != null) {
                c.markAsAcknowledged();
                interfaceName = DOMUtils.getElementText((Element)c.element);
            } else {
                interfaceName = globalInterfaceSetting;
            }
            if (VetoableChangeListener.class.getName().equals(interfaceName)) {
                this.addSupport(VetoableChangeListener.class, VetoableChangeSupport.class, co.implClass);
            }
            if (!PropertyChangeListener.class.getName().equals(interfaceName)) continue;
            this.addSupport(PropertyChangeListener.class, PropertyChangeSupport.class, co.implClass);
        }
        return true;
    }

    private void addSupport(Class listener, Class support, JDefinedClass target) {
        JFieldVar field = target.field(4, support, "support");
        field.annotate(XmlTransient.class);
        field.init(JExpr.direct((String)("new " + support.getSimpleName() + "(this)")));
        block0: for (Method method : support.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (method.getName().startsWith("add")) {
                for (Class<?> param : method.getParameterTypes()) {
                    if (!param.getName().equals(listener.getName())) continue;
                    this.addMethod(method, target);
                    break;
                }
            }
            if (!method.getName().startsWith("remove")) continue;
            for (Class<?> param : method.getParameterTypes()) {
                if (!param.getName().equals(listener.getName())) continue;
                this.addMethod(method, target);
                continue block0;
            }
        }
    }

    private void addMethod(Method method, JDefinedClass target) {
        JMethod addListener = target.method(1, method.getReturnType(), method.getName());
        Class<?>[] params = method.getParameterTypes();
        JInvocation inv = addListener.body().invoke((JExpression)JExpr.ref((String)"support"), method.getName());
        for (int i = 0; i < params.length; ++i) {
            inv.arg((JExpression)addListener.param(params[i], "param" + i));
        }
    }
}

