/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.tree;

import java.util.ArrayList;
import java.util.Collection;
import org.jvnet.jaxbcommons.tree.NodeVisitor;

public class Node {
    private String name;
    private Class type;
    private Object value;
    private Node[] children;

    public Node(String name, Class type, Object value, Node[] children) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.children = children;
    }

    public Node(String name, Class type, Object value, Node[][] children) {
        this(name, type, value, Node.concat(children));
    }

    public Node[] getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public static Node[] concat(Node[][] nodeArrays) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (int index = 0; index < nodeArrays.length; ++index) {
            Node[] nodes = nodeArrays[index];
            for (int jndex = 0; jndex < nodes.length; ++jndex) {
                Node node = nodes[jndex];
                list.add(node);
            }
        }
        return Node.toArray(list);
    }

    public static Node[] toArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new Node[collection.size()]);
    }

    public Object visit(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitNode(this);
    }
}

