/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.tests;

import java.io.File;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSamplesTest
extends TestCase {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String DEFAULT_SAMPLES_DIRECTORY_NAME = "src/test/samples";

    protected abstract String getContextPath();

    protected abstract void checkSample(JAXBContext var1, File var2) throws Exception;

    protected void checkSample(File sample) throws Exception {
        this.logger.debug((Object)("Checking sample [" + sample.getName() + "]."));
        JAXBContext context = this.createContext();
        this.checkSample(context, sample);
    }

    public void testSamples() throws Exception {
        this.logger.debug((Object)"Testing samples.");
        File[] sampleFiles = this.getSampleFiles();
        for (int index = 0; index < sampleFiles.length; ++index) {
            File sampleFile = sampleFiles[index];
            this.checkSample(sampleFile);
        }
        this.logger.debug((Object)"Finished testing samples.");
    }

    protected File getBaseDir() {
        try {
            return new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile().getParentFile().getAbsoluteFile();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected File getSamplesDirectory() {
        return new File(this.getBaseDir(), this.getSamplesDirectoryName());
    }

    protected String getSamplesDirectoryName() {
        return DEFAULT_SAMPLES_DIRECTORY_NAME;
    }

    protected File[] getSampleFiles() {
        Collection files = FileUtils.listFiles((File)this.getSamplesDirectory(), (String[])new String[]{"xml"}, (boolean)true);
        return files.toArray(new File[files.size()]);
    }

    protected JAXBContext createContext() throws Exception {
        return JAXBContext.newInstance((String)this.getContextPath());
    }
}

