/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbvalidation.runtime.tests;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import junit.framework.AssertionFailedError;
import org.jvnet.jaxbcommons.tests.AbstractSamplesTest;
import org.jvnet.jaxbvalidation.validator.ObjectValidator;
import org.jvnet.jaxbvalidation.validator.ObjectValidatorFactory;

public abstract class RoundtripTest
extends AbstractSamplesTest {
    public ObjectValidator getObjectValidator(Object object) {
        Class<?> objectClass = object.getClass();
        String name = objectClass.getPackage().getName();
        if (!name.endsWith(".impl")) {
            throw new IllegalArgumentException("Object class [" + name + "] does not belong to the implementation package.");
        }
        String objectValidatorFactoryClassName = name.substring(0, name.length() - 4) + "ObjectValidatorFactory";
        try {
            Class<?> objectValidatiorFactoryClass = Class.forName(objectValidatorFactoryClassName);
            ObjectValidatorFactory objectValidatorFactory = (ObjectValidatorFactory)objectValidatiorFactoryClass.newInstance();
            return objectValidatorFactory.newInstance(objectClass);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to instantiate the object validator for object class [" + objectClass.getName() + "]");
        }
    }

    protected void checkSample(JAXBContext context, File sample) throws Exception {
        this.logger.debug((Object)"Parsing the sample.");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Object object = unmarshaller.unmarshal(sample);
        this.logger.debug((Object)"Instantiating the object validator.");
        ObjectValidator objectValidator = this.getObjectValidator(object);
        this.logger.debug((Object)"Validating.");
        objectValidator.check(null, new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new AssertionFailedError("No validation problems expected.\n" + event.toString());
            }
        }, object);
        this.logger.debug((Object)"Validation is finished.");
    }
}

