/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.util.Date;
import java.util.Map;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.transform.poi.PoiUtil;
import org.jxls.transform.poi.WritableCellValue;
import org.jxls.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiCellData
extends CellData {
    private static Logger logger = LoggerFactory.getLogger(PoiCellData.class);
    private PoiRowData poiRowData;
    private RichTextString richTextString;
    private CellStyle cellStyle;
    private Hyperlink hyperlink;
    private Comment comment;
    private String commentAuthor;
    private Cell cell;

    public PoiCellData(CellRef cellRef) {
        super(cellRef);
    }

    public PoiCellData(CellRef cellRef, Cell cell) {
        super(cellRef);
        this.cell = cell;
    }

    public static PoiCellData createCellData(PoiRowData poiRowData, CellRef cellRef, Cell cell) {
        PoiCellData cellData = new PoiCellData(cellRef, cell);
        cellData.poiRowData = poiRowData;
        cellData.readCell(cell);
        cellData.updateFormulaValue();
        return cellData;
    }

    public void readCell(Cell cell) {
        this.readCellGeneralInfo(cell);
        this.readCellContents(cell);
        this.readCellStyle(cell);
    }

    private void readCellGeneralInfo(Cell cell) {
        this.hyperlink = cell.getHyperlink();
        try {
            this.comment = cell.getCellComment();
        }
        catch (Exception e) {
            logger.error("Failed to read cell comment at " + new CellReference(cell).formatAsString(), (Throwable)e);
            return;
        }
        if (this.comment != null) {
            this.commentAuthor = this.comment.getAuthor();
        }
        if (this.comment != null && this.comment.getString() != null && this.comment.getString().getString() != null) {
            String[] commentLines;
            String commentString = this.comment.getString().getString();
            for (String commentLine : commentLines = commentString.split("\\n")) {
                if (!this.isJxlsParamsComment(commentLine)) continue;
                this.processJxlsParams(commentLine);
                this.comment = null;
                return;
            }
            this.setCellComment(commentString);
        }
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    private void readCellContents(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                this.richTextString = cell.getRichStringCellValue();
                this.cellValue = this.richTextString.getString();
                this.cellType = CellData.CellType.STRING;
                break;
            }
            case BOOLEAN: {
                this.cellValue = cell.getBooleanCellValue();
                this.cellType = CellData.CellType.BOOLEAN;
                break;
            }
            case NUMERIC: {
                this.readNumericCellContents(cell);
                break;
            }
            case FORMULA: {
                this.formula = cell.getCellFormula();
                this.cellValue = this.formula;
                this.cellType = CellData.CellType.FORMULA;
                break;
            }
            case ERROR: {
                this.cellValue = cell.getErrorCellValue();
                this.cellType = CellData.CellType.ERROR;
                break;
            }
            case BLANK: 
            case _NONE: {
                this.cellValue = null;
                this.cellType = CellData.CellType.BLANK;
            }
        }
        this.evaluationResult = this.cellValue;
    }

    private void readNumericCellContents(Cell cell) {
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            this.cellValue = cell.getDateCellValue();
            this.cellType = CellData.CellType.DATE;
        } else {
            this.cellValue = cell.getNumericCellValue();
            this.cellType = CellData.CellType.NUMBER;
        }
    }

    private void readCellStyle(Cell cell) {
        this.cellStyle = cell.getCellStyle();
    }

    public void writeToCell(Cell cell, Context context, PoiTransformer transformer) {
        this.evaluate(context);
        if (this.evaluationResult instanceof WritableCellValue) {
            cell.setCellStyle(this.cellStyle);
            ((WritableCellValue)this.evaluationResult).writeToCell(cell, context);
        } else {
            CellStyle dataFormatCellStyle;
            this.updateCellGeneralInfo(cell);
            this.updateCellContents(cell);
            CellStyle targetCellStyle = this.cellStyle;
            if (context.getConfig().isIgnoreSourceCellStyle() && (dataFormatCellStyle = this.findCellStyle(this.evaluationResult, context.getConfig().getCellStyleMap(), transformer)) != null) {
                targetCellStyle = dataFormatCellStyle;
            }
            this.updateCellStyle(cell, targetCellStyle);
            this.poiRowData.getPoiSheetData().updateConditionalFormatting(this, cell);
        }
    }

    private CellStyle findCellStyle(Object evaluationResult, Map<String, String> cellStyleMap, PoiTransformer transformer) {
        if (evaluationResult == null || cellStyleMap == null) {
            return null;
        }
        String cellName = cellStyleMap.get(evaluationResult.getClass().getSimpleName());
        if (cellName == null) {
            return null;
        }
        Sheet sheet = this.cell.getSheet();
        CellRef cellRef = new CellRef(cellName);
        if (cellRef.getSheetName() == null) {
            cellRef.setSheetName(sheet.getSheetName());
        }
        return transformer.getCellStyle(cellRef);
    }

    private void updateCellGeneralInfo(Cell cell) {
        if (this.targetCellType != CellData.CellType.FORMULA) {
            cell.setCellType(PoiCellData.getPoiCellType(this.targetCellType));
        }
        if (this.hyperlink != null) {
            cell.setHyperlink(this.hyperlink);
        }
        if (this.comment != null && !PoiUtil.isJxComment(this.getCellComment())) {
            PoiUtil.setCellComment(cell, this.getCellComment(), this.commentAuthor, null);
        }
    }

    static CellType getPoiCellType(CellData.CellType cellType) {
        if (cellType == null) {
            return CellType.BLANK;
        }
        switch (cellType) {
            case STRING: {
                return CellType.STRING;
            }
            case BOOLEAN: {
                return CellType.BOOLEAN;
            }
            case NUMBER: 
            case DATE: {
                return CellType.NUMERIC;
            }
            case FORMULA: {
                return CellType.FORMULA;
            }
            case ERROR: {
                return CellType.ERROR;
            }
            case BLANK: {
                return CellType.BLANK;
            }
        }
        return CellType.BLANK;
    }

    private void updateCellContents(Cell cell) {
        switch (this.targetCellType) {
            case STRING: {
                this.updateStringCellContents(cell);
                break;
            }
            case BOOLEAN: {
                cell.setCellValue(((Boolean)this.evaluationResult).booleanValue());
                break;
            }
            case DATE: {
                cell.setCellValue((Date)this.evaluationResult);
                break;
            }
            case NUMBER: {
                cell.setCellValue(((Number)this.evaluationResult).doubleValue());
                break;
            }
            case FORMULA: {
                this.updateFormulaCellContents(cell);
                break;
            }
            case ERROR: {
                cell.setCellErrorValue(((Byte)this.evaluationResult).byteValue());
                break;
            }
            case BLANK: {
                cell.setCellType(CellType.BLANK);
            }
        }
    }

    private void updateStringCellContents(Cell cell) {
        String result;
        if (this.evaluationResult instanceof byte[]) {
            return;
        }
        String string = result = this.evaluationResult != null ? this.evaluationResult.toString() : "";
        if (this.cellValue != null && this.cellValue.equals(result)) {
            cell.setCellValue(this.richTextString);
        } else {
            cell.setCellValue(result);
        }
    }

    private void updateFormulaCellContents(Cell cell) {
        try {
            if (Util.formulaContainsJointedCellRef((String)((String)this.evaluationResult))) {
                cell.setCellValue((String)this.evaluationResult);
            } else {
                cell.setCellFormula((String)this.evaluationResult);
            }
        }
        catch (FormulaParseException e) {
            try {
                String formulaString = this.evaluationResult.toString();
                logger.error("Failed to set cell formula " + formulaString + " for cell " + this.toString(), (Throwable)e);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(formulaString);
            }
            catch (Exception ex) {
                logger.warn("Failed to convert formula to string for cell " + this.toString());
            }
        }
    }

    private void updateCellStyle(Cell cell, CellStyle cellStyle) {
        cell.setCellStyle(cellStyle);
    }
}

