/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialMappingRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserRoleMappingRepresentation;

public class RealmRepresentation {
    protected String self;
    protected String id;
    protected String realm;
    protected Integer tokenLifespan;
    protected Integer accessCodeLifespan;
    protected Integer accessCodeLifespanUserAction;
    protected Boolean enabled;
    protected Boolean accountManagement;
    protected Boolean sslNotRequired;
    protected Boolean cookieLoginAllowed;
    protected Boolean registrationAllowed;
    protected Boolean verifyEmail;
    protected Boolean resetPasswordAllowed;
    protected Boolean social;
    protected Boolean automaticRegistrationAfterSocialLogin;
    protected String privateKey;
    protected String publicKey;
    protected List<RoleRepresentation> roles;
    protected List<String> defaultRoles;
    protected Set<String> requiredCredentials;
    protected Set<String> requiredApplicationCredentials;
    protected Set<String> requiredOAuthClientCredentials;
    protected String passwordPolicy;
    protected List<UserRepresentation> users;
    protected List<UserRoleMappingRepresentation> roleMappings;
    protected List<ScopeMappingRepresentation> scopeMappings;
    protected Map<String, List<UserRoleMappingRepresentation>> applicationRoleMappings;
    protected Map<String, List<ScopeMappingRepresentation>> applicationScopeMappings;
    protected List<SocialMappingRepresentation> socialMappings;
    protected List<ApplicationRepresentation> applications;
    protected List<OAuthClientRepresentation> oauthClients;
    protected Map<String, String> socialProviders;
    protected Map<String, String> smtpServer;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public List<UserRepresentation> getUsers() {
        return this.users;
    }

    public List<ApplicationRepresentation> getApplications() {
        return this.applications;
    }

    public ApplicationRepresentation resource(String name) {
        ApplicationRepresentation resource = new ApplicationRepresentation();
        if (this.applications == null) {
            this.applications = new ArrayList<ApplicationRepresentation>();
        }
        this.applications.add(resource);
        resource.setName(name);
        return resource;
    }

    public void setUsers(List<UserRepresentation> users) {
        this.users = users;
    }

    public UserRepresentation user(String username) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        if (this.users == null) {
            this.users = new ArrayList<UserRepresentation>();
        }
        this.users.add(user);
        return user;
    }

    public void setApplications(List<ApplicationRepresentation> applications) {
        this.applications = applications;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getAccountManagement() {
        return this.accountManagement;
    }

    public void setAccountManagement(Boolean accountManagement) {
        this.accountManagement = accountManagement;
    }

    public Boolean isSslNotRequired() {
        return this.sslNotRequired;
    }

    public void setSslNotRequired(Boolean sslNotRequired) {
        this.sslNotRequired = sslNotRequired;
    }

    public Boolean isCookieLoginAllowed() {
        return this.cookieLoginAllowed;
    }

    public void setCookieLoginAllowed(Boolean cookieLoginAllowed) {
        this.cookieLoginAllowed = cookieLoginAllowed;
    }

    public Integer getTokenLifespan() {
        return this.tokenLifespan;
    }

    public void setTokenLifespan(Integer tokenLifespan) {
        this.tokenLifespan = tokenLifespan;
    }

    public List<UserRoleMappingRepresentation> getRoleMappings() {
        return this.roleMappings;
    }

    public UserRoleMappingRepresentation roleMapping(String username) {
        UserRoleMappingRepresentation mapping = new UserRoleMappingRepresentation();
        mapping.setUsername(username);
        if (this.roleMappings == null) {
            this.roleMappings = new ArrayList<UserRoleMappingRepresentation>();
        }
        this.roleMappings.add(mapping);
        return mapping;
    }

    public List<ScopeMappingRepresentation> getScopeMappings() {
        return this.scopeMappings;
    }

    public ScopeMappingRepresentation scopeMapping(String username) {
        ScopeMappingRepresentation mapping = new ScopeMappingRepresentation();
        mapping.setUsername(username);
        if (this.scopeMappings == null) {
            this.scopeMappings = new ArrayList<ScopeMappingRepresentation>();
        }
        this.scopeMappings.add(mapping);
        return mapping;
    }

    public List<SocialMappingRepresentation> getSocialMappings() {
        return this.socialMappings;
    }

    public SocialMappingRepresentation socialMapping(String username) {
        SocialMappingRepresentation mapping = new SocialMappingRepresentation();
        mapping.setUsername(username);
        if (this.socialMappings == null) {
            this.socialMappings = new ArrayList<SocialMappingRepresentation>();
        }
        this.socialMappings.add(mapping);
        return mapping;
    }

    public Set<String> getRequiredCredentials() {
        return this.requiredCredentials;
    }

    public void setRequiredCredentials(Set<String> requiredCredentials) {
        this.requiredCredentials = requiredCredentials;
    }

    public Set<String> getRequiredApplicationCredentials() {
        return this.requiredApplicationCredentials;
    }

    public void setRequiredApplicationCredentials(Set<String> requiredApplicationCredentials) {
        this.requiredApplicationCredentials = requiredApplicationCredentials;
    }

    public Set<String> getRequiredOAuthClientCredentials() {
        return this.requiredOAuthClientCredentials;
    }

    public void setRequiredOAuthClientCredentials(Set<String> requiredOAuthClientCredentials) {
        this.requiredOAuthClientCredentials = requiredOAuthClientCredentials;
    }

    public String getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(String passwordPolicy) {
        this.passwordPolicy = passwordPolicy;
    }

    public Integer getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public void setAccessCodeLifespan(Integer accessCodeLifespan) {
        this.accessCodeLifespan = accessCodeLifespan;
    }

    public Integer getAccessCodeLifespanUserAction() {
        return this.accessCodeLifespanUserAction;
    }

    public void setAccessCodeLifespanUserAction(Integer accessCodeLifespanUserAction) {
        this.accessCodeLifespanUserAction = accessCodeLifespanUserAction;
    }

    public List<RoleRepresentation> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleRepresentation> roles) {
        this.roles = roles;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setDefaultRoles(List<String> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public Boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public void setRegistrationAllowed(Boolean registrationAllowed) {
        this.registrationAllowed = registrationAllowed;
    }

    public Boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public void setVerifyEmail(Boolean verifyEmail) {
        this.verifyEmail = verifyEmail;
    }

    public Boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public void setResetPasswordAllowed(Boolean resetPassword) {
        this.resetPasswordAllowed = resetPassword;
    }

    public Boolean isSocial() {
        return this.social;
    }

    public void setSocial(Boolean social) {
        this.social = social;
    }

    public Boolean isAutomaticRegistrationAfterSocialLogin() {
        return this.automaticRegistrationAfterSocialLogin;
    }

    public void setAutomaticRegistrationAfterSocialLogin(Boolean automaticRegistrationAfterSocialLogin) {
        this.automaticRegistrationAfterSocialLogin = automaticRegistrationAfterSocialLogin;
    }

    public Map<String, String> getSocialProviders() {
        return this.socialProviders;
    }

    public void setSocialProviders(Map<String, String> socialProviders) {
        this.socialProviders = socialProviders;
    }

    public Map<String, String> getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(Map<String, String> smtpServer) {
        this.smtpServer = smtpServer;
    }

    public List<OAuthClientRepresentation> getOauthClients() {
        return this.oauthClients;
    }

    public void setOauthClients(List<OAuthClientRepresentation> oauthClients) {
        this.oauthClients = oauthClients;
    }

    public Map<String, List<UserRoleMappingRepresentation>> getApplicationRoleMappings() {
        return this.applicationRoleMappings;
    }

    public void setApplicationRoleMappings(Map<String, List<UserRoleMappingRepresentation>> applicationRoleMappings) {
        this.applicationRoleMappings = applicationRoleMappings;
    }

    public Map<String, List<ScopeMappingRepresentation>> getApplicationScopeMappings() {
        return this.applicationScopeMappings;
    }

    public void setApplicationScopeMappings(Map<String, List<ScopeMappingRepresentation>> applicationScopeMappings) {
        this.applicationScopeMappings = applicationScopeMappings;
    }
}

