/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws.crypto;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import org.keycloak.common.util.Base64Url;
import org.keycloak.crypto.HashException;
import org.keycloak.crypto.JavaAlgorithm;

public class HashUtils {
    public static String accessTokenHash(String jwtAlgorithmName, String input, boolean full) {
        return HashUtils.accessTokenHash(jwtAlgorithmName, null, input, full);
    }

    public static String accessTokenHash(String jwtAlgorithmName, String curve, String input, boolean full) {
        byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);
        String javaAlgName = JavaAlgorithm.getJavaAlgorithmForHash(jwtAlgorithmName, curve);
        byte[] hash = HashUtils.hash(javaAlgName, inputBytes);
        return HashUtils.encodeHashToOIDC(hash, full);
    }

    public static String accessTokenHash(String jwtAlgorithmName, String input) {
        return HashUtils.accessTokenHash(jwtAlgorithmName, null, input, false);
    }

    public static String accessTokenHash(String jwtAlgorithmName, String curve, String input) {
        return HashUtils.accessTokenHash(jwtAlgorithmName, curve, input, false);
    }

    public static byte[] hash(String javaAlgorithmName, byte[] inputBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance(javaAlgorithmName);
            md.update(inputBytes);
            return md.digest();
        }
        catch (Exception e) {
            throw new HashException("Error when creating token hash", e);
        }
    }

    public static String encodeHashToOIDC(byte[] hash) {
        return HashUtils.encodeHashToOIDC(hash, false);
    }

    public static String encodeHashToOIDC(byte[] hash, boolean full) {
        int hashLength = full ? hash.length : hash.length / 2;
        byte[] hashInput = Arrays.copyOf(hash, hashLength);
        return Base64Url.encode((byte[])hashInput);
    }
}

