/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ScopeUpdatedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String name;
    private String serverId;

    public static ScopeUpdatedEvent create(String id, String name, String serverId) {
        ScopeUpdatedEvent event = new ScopeUpdatedEvent();
        event.id = id;
        event.name = name;
        event.serverId = serverId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopeUpdatedEvent that = (ScopeUpdatedEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.serverId, that.serverId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.name, this.serverId);
    }

    public String toString() {
        return String.format("ScopeUpdatedEvent [ id=%s, name=%s ]", this.id, this.name);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.scopeUpdated(this.id, this.name, this.serverId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ScopeUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ScopeUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.id, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.name, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.serverId, (ObjectOutput)output);
        }

        public ScopeUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ScopeUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ScopeUpdatedEvent res = new ScopeUpdatedEvent();
            res.id = MarshallUtil.unmarshallString((ObjectInput)input);
            res.name = MarshallUtil.unmarshallString((ObjectInput)input);
            res.serverId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

