/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class OfflinePersistentLoaderContext
extends SessionLoader.LoaderContext {
    private final int sessionsTotal;
    private final int sessionsPerSegment;

    public OfflinePersistentLoaderContext(int sessionsTotal, int sessionsPerSegment) {
        super(OfflinePersistentLoaderContext.computeSegmentsCount(sessionsTotal, sessionsPerSegment));
        this.sessionsTotal = sessionsTotal;
        this.sessionsPerSegment = sessionsPerSegment;
    }

    private static int computeSegmentsCount(int sessionsTotal, int sessionsPerSegment) {
        int segmentsCount = sessionsTotal / sessionsPerSegment;
        if (sessionsTotal % sessionsPerSegment >= 1) {
            ++segmentsCount;
        }
        return segmentsCount;
    }

    public int getSessionsTotal() {
        return this.sessionsTotal;
    }

    public int getSessionsPerSegment() {
        return this.sessionsPerSegment;
    }

    public String toString() {
        return "OfflinePersistentLoaderContext [ " + " sessionsTotal: " + this.sessionsTotal + ", sessionsPerSegment: " + this.sessionsPerSegment + ", segmentsCount: " + this.getSegmentsCount() + " ]";
    }
}

