/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.entities.GroupListQuery;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@SerializeWith(value=ExternalizerImpl.class)
public class GroupListPredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String realm;

    public static GroupListPredicate create() {
        return new GroupListPredicate();
    }

    public GroupListPredicate realm(String realm) {
        this.realm = realm;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        GroupListQuery groupList;
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        return value instanceof GroupListQuery && (groupList = (GroupListQuery)value).getRealm().equals(this.realm);
    }

    public static class ExternalizerImpl
    implements Externalizer<GroupListPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, GroupListPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realm, (ObjectOutput)output);
        }

        public GroupListPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public GroupListPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            GroupListPredicate res = new GroupListPredicate();
            res.realm = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

