/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class UserFullInvalidationEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String userId;
    private String username;
    private String email;
    private String realmId;
    private boolean identityFederationEnabled;
    private Map<String, String> federatedIdentities;

    public static UserFullInvalidationEvent create(String userId, String username, String email, String realmId, boolean identityFederationEnabled, Collection<FederatedIdentityModel> federatedIdentities) {
        UserFullInvalidationEvent event = new UserFullInvalidationEvent();
        event.userId = userId;
        event.username = username;
        event.email = email;
        event.realmId = realmId;
        event.identityFederationEnabled = identityFederationEnabled;
        if (identityFederationEnabled) {
            event.federatedIdentities = new HashMap<String, String>();
            for (FederatedIdentityModel socialLink : federatedIdentities) {
                event.federatedIdentities.put(socialLink.getIdentityProvider(), socialLink.getUserId());
            }
        }
        return event;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public Map<String, String> getFederatedIdentities() {
        return this.federatedIdentities;
    }

    public String toString() {
        return String.format("UserFullInvalidationEvent [ userId=%s, username=%s, email=%s ]", this.userId, this.username, this.email);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.fullUserInvalidation(this.userId, this.username, this.email, this.realmId, this.identityFederationEnabled, this.federatedIdentities, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<UserFullInvalidationEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, UserFullInvalidationEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.userId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.username, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.email, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            output.writeBoolean(obj.identityFederationEnabled);
            KeycloakMarshallUtil.writeMap(obj.federatedIdentities, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
        }

        public UserFullInvalidationEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserFullInvalidationEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserFullInvalidationEvent res = new UserFullInvalidationEvent();
            res.userId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.username = MarshallUtil.unmarshallString((ObjectInput)input);
            res.email = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.identityFederationEnabled = input.readBoolean();
            res.federatedIdentities = KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, HashMap::new);
            return res;
        }
    }
}

