/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.store.ResourceAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.utils.StreamsUtil;

public class JPAResourceStore
implements ResourceStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAResourceStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Resource create(ResourceServer resourceServer, String id, String name, String owner) {
        ResourceEntity entity = new ResourceEntity();
        if (id == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(id);
        }
        entity.setName(name);
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer).getId());
        entity.setOwner(owner);
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        return new ResourceAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public void delete(String id) {
        ResourceEntity resource = (ResourceEntity)this.entityManager.getReference(ResourceEntity.class, (Object)id);
        if (resource == null) {
            return;
        }
        resource.getScopes().clear();
        this.entityManager.remove((Object)resource);
    }

    public Resource findById(ResourceServer resourceServer, String id) {
        if (id == null) {
            return null;
        }
        ResourceEntity entity = (ResourceEntity)this.entityManager.find(ResourceEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new ResourceAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public void findByOwner(ResourceServer resourceServer, String ownerId, Consumer<Resource> consumer) {
        this.findByOwnerFilter(ownerId, resourceServer, consumer, -1, -1);
    }

    private void findByOwnerFilter(String ownerId, ResourceServer resourceServer, Consumer<Resource> consumer, int firstResult, int maxResult) {
        String queryName;
        boolean pagination = firstResult > -1 && maxResult > -1;
        String string = queryName = pagination ? "findResourceIdByOwnerOrdered" : "findResourceIdByOwner";
        if (resourceServer == null) {
            queryName = pagination ? "findAnyResourceIdByOwnerOrdered" : "findAnyResourceIdByOwner";
        }
        TypedQuery query = this.entityManager.createNamedQuery(queryName, ResourceEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("owner", (Object)ownerId);
        if (resourceServer != null) {
            query.setParameter("serverId", (Object)resourceServer.getId());
        }
        if (pagination) {
            query.setFirstResult(firstResult);
            query.setMaxResults(maxResult);
        }
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        StreamsUtil.closing(query.getResultStream().map(id -> resourceStore.findById(resourceServer, id.getId()))).forEach(consumer);
    }

    public List<Resource> findByResourceServer(ResourceServer resourceServer) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByServerId", String.class);
        query.setParameter("serverId", (Object)(resourceServer == null ? null : resourceServer.getId()));
        List result = query.getResultList();
        LinkedList<Resource> list = new LinkedList<Resource>();
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        for (String id : result) {
            Resource resource = resourceStore.findById(resourceServer, id);
            if (resource == null) continue;
            list.add(resource);
        }
        return list;
    }

    public List<Resource> find(ResourceServer resourceServer, Map<Resource.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(String.class);
        Root root = querybuilder.from(ResourceEntity.class);
        querybuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (resourceServer != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer"), (Object)resourceServer.getId()));
        }
        attributes.forEach((filterOption, value) -> {
            switch (filterOption) {
                case ID: 
                case OWNER: {
                    predicates.add(root.get(filterOption.getName()).in((Object[])value));
                    break;
                }
                case SCOPE_ID: {
                    predicates.add(root.join("scopes").get("id").in((Object[])value));
                    break;
                }
                case OWNER_MANAGED_ACCESS: {
                    predicates.add(builder.equal((Expression)root.get(filterOption.getName()), (Object)Boolean.valueOf(value[0])));
                    break;
                }
                case URI: {
                    predicates.add(builder.lower((Expression)root.join("uris")).in(new Object[]{value[0].toLowerCase()}));
                    break;
                }
                case URI_NOT_NULL: {
                    Expression urisSize = builder.size((Expression)root.get("uris"));
                    predicates.add(builder.notEqual(urisSize, (Object)0));
                    break;
                }
                case NAME: 
                case TYPE: {
                    predicates.add(builder.like(builder.lower((Expression)root.get(filterOption.getName())), "%" + value[0].toLowerCase() + "%"));
                    break;
                }
                case EXACT_NAME: {
                    predicates.add(builder.equal(builder.lower((Expression)root.get(filterOption.getName())), (Object)value[0].toLowerCase()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported filter [" + filterOption + "]");
                }
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        List result = PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultList();
        LinkedList<Resource> list = new LinkedList<Resource>();
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        for (String id : result) {
            Resource resource = resourceStore.findById(resourceServer, id);
            if (resource == null) continue;
            list.add(resource);
        }
        return list;
    }

    public void findByScopes(ResourceServer resourceServer, Set<Scope> scopes, Consumer<Resource> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByScope", ResourceEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopes.stream().map(Scope::getId).collect(Collectors.toSet()));
        query.setParameter("serverId", (Object)(resourceServer == null ? null : resourceServer.getId()));
        StoreFactory storeFactory = this.provider.getStoreFactory();
        query.getResultList().stream().map(id -> new ResourceAdapter((ResourceEntity)id, this.entityManager, storeFactory)).forEach(consumer);
    }

    public Resource findByName(ResourceServer resourceServer, String name, String ownerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByName", ResourceEntity.class);
        query.setParameter("serverId", (Object)(resourceServer == null ? null : resourceServer.getId()));
        query.setParameter("name", (Object)name);
        query.setParameter("ownerId", (Object)ownerId);
        try {
            return new ResourceAdapter((ResourceEntity)query.getSingleResult(), this.entityManager, this.provider.getStoreFactory());
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public void findByType(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
        this.findByType(resourceServer, type, resourceServer == null ? null : resourceServer.getId(), consumer);
    }

    public void findByType(ResourceServer resourceServer, String type, String owner, Consumer<Resource> consumer) {
        TypedQuery query = owner != null ? this.entityManager.createNamedQuery("findResourceIdByType", ResourceEntity.class) : this.entityManager.createNamedQuery("findResourceIdByTypeNoOwner", ResourceEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("type", (Object)type);
        if (owner != null) {
            query.setParameter("ownerId", (Object)owner);
        }
        query.setParameter("serverId", (Object)(resourceServer == null ? null : resourceServer.getId()));
        StoreFactory storeFactory = this.provider.getStoreFactory();
        query.getResultList().stream().map(entity -> new ResourceAdapter((ResourceEntity)entity, this.entityManager, storeFactory)).forEach(consumer);
    }

    public void findByTypeInstance(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByTypeInstance", ResourceEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("type", (Object)type);
        query.setParameter("serverId", (Object)(resourceServer == null ? null : resourceServer.getId()));
        StoreFactory storeFactory = this.provider.getStoreFactory();
        query.getResultList().stream().map(entity -> new ResourceAdapter((ResourceEntity)entity, this.entityManager, storeFactory)).forEach(consumer);
    }
}

