/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.dblock;

import java.time.Duration;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.locking.GlobalLockProvider;

public class DBLockGlobalLockProvider
implements GlobalLockProvider {
    private static final Logger LOG = Logger.getLogger(DBLockGlobalLockProvider.class);
    public static final String DATABASE = "database";
    private final KeycloakSession session;
    private final DBLockProvider dbLockProvider;

    public DBLockGlobalLockProvider(KeycloakSession session, DBLockProvider dbLockProvider) {
        this.session = session;
        this.dbLockProvider = dbLockProvider;
    }

    private static DBLockProvider.Namespace stringToNamespace(String lockName) {
        switch (lockName) {
            case "database": {
                return DBLockProvider.Namespace.DATABASE;
            }
            case "keycloak-boot": {
                return DBLockProvider.Namespace.KEYCLOAK_BOOT;
            }
        }
        throw new RuntimeException("Lock with name " + lockName + " not supported by DBLockGlobalLockProvider.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V withLock(String lockName, Duration timeToWaitForLock, KeycloakSessionTaskWithResult<V> task) {
        Objects.requireNonNull(lockName, "lockName cannot be null");
        if (timeToWaitForLock != null) {
            LOG.debug((Object)"DBLockGlobalLockProvider does not support setting timeToWaitForLock per lock.");
        }
        if (this.dbLockProvider.getCurrentLock() != null) {
            throw new IllegalStateException("this lock is not reentrant, already locked for " + (Object)((Object)this.dbLockProvider.getCurrentLock()));
        }
        this.dbLockProvider.waitForLock(DBLockGlobalLockProvider.stringToNamespace(lockName));
        try {
            Object object = task.run(this.session);
            return (V)object;
        }
        finally {
            this.releaseLock(lockName);
        }
    }

    private void releaseLock(String lockName) {
        if (this.dbLockProvider.getCurrentLock() != DBLockGlobalLockProvider.stringToNamespace(lockName)) {
            throw new RuntimeException("Requested releasing lock with name " + lockName + ", but lock is currently acquired for " + (Object)((Object)this.dbLockProvider.getCurrentLock()) + ".");
        }
        this.dbLockProvider.releaseLock();
    }

    public void forceReleaseAllLocks() {
        if (!this.dbLockProvider.supportsForcedUnlock()) {
            throw new IllegalStateException("Forced unlock requested, but provider " + this.dbLockProvider + " does not support it.");
        }
        this.dbLockProvider.releaseLock();
    }

    public void close() {
    }
}

