/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authorization;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoDocs;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodResourceEntityDelegate;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodResourceEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@ProtoDocs(value={@ProtoDoc(value="@Indexed"), @ProtoDoc(value="schema-version: 1")})
public class HotRodResourceEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=2)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoField(number=4)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String name;
    @ProtoField(number=5)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String nameLowercase;
    @ProtoField(number=6)
    public String displayName;
    @ProtoField(number=7)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<String> uris;
    @ProtoField(number=8)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"filename\"))")
    public String type;
    @ProtoField(number=9)
    public String iconUri;
    @ProtoField(number=10)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String owner;
    @ProtoField(number=11)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Boolean ownerManagedAccess;
    @ProtoField(number=12)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public String resourceServerId;
    @ProtoField(number=13)
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    public Set<String> scopeIds;
    @ProtoField(number=14)
    public Set<HotRodAttributeEntityNonIndexed> attributes;

    public boolean equals(Object o) {
        return HotRodResourceEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodResourceEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodResourceEntity
    extends UpdatableHotRodEntityDelegateImpl<HotRodResourceEntity>
    implements MapResourceEntity {
        public String getId() {
            return ((HotRodResourceEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodResourceEntity entity = (HotRodResourceEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setName(String name) {
            HotRodResourceEntity entity = (HotRodResourceEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.name, name);
            entity.name = name;
            entity.nameLowercase = name == null ? null : name.toLowerCase();
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodResourceEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodResourceEntitySchema
    extends GeneratedSchema {
        public static final HotRodResourceEntitySchema INSTANCE = new HotRodResourceEntitySchemaImpl();
    }
}

