/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntityImpl;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapAuthenticationFlowEntity
extends UpdatableEntity,
AbstractEntity {
    public static MapAuthenticationFlowEntity fromModel(AuthenticationFlowModel model) {
        MapAuthenticationFlowEntityImpl entity = new MapAuthenticationFlowEntityImpl();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setTopLevel(model.isTopLevel());
        return entity;
    }

    public static AuthenticationFlowModel toModel(MapAuthenticationFlowEntity entity) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        Boolean builtIn = entity.isBuiltIn();
        model.setBuiltIn(builtIn == null ? false : builtIn);
        model.setDescription(entity.getDescription());
        model.setProviderId(entity.getProviderId());
        Boolean topLevel = entity.isTopLevel();
        model.setTopLevel(topLevel == null ? false : topLevel);
        return model;
    }

    public String getAlias();

    public void setAlias(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public String getProviderId();

    public void setProviderId(String var1);

    public Boolean isBuiltIn();

    public void setBuiltIn(Boolean var1);

    public Boolean isTopLevel();

    public void setTopLevel(Boolean var1);
}

