/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.MapPolicyAdapter;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public class MapPolicyStore
implements PolicyStore {
    private static final Logger LOG = Logger.getLogger(MapPolicyStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapStorage<MapPolicyEntity, Policy> store;
    private final boolean storeHasRealmId;

    public MapPolicyStore(MapStorage<MapPolicyEntity, Policy> policyStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.store = policyStore;
        this.storeHasRealmId = this.store instanceof HasRealmId;
    }

    private Function<MapPolicyEntity, Policy> entityToAdapterFunc(RealmModel realm, ResourceServer resourceServer) {
        return origEntity -> new MapPolicyAdapter(realm, resourceServer, (MapPolicyEntity)origEntity, this.authorizationProvider.getStoreFactory());
    }

    private MapStorage<MapPolicyEntity, Policy> storeWithRealm(RealmModel realm) {
        if (this.storeHasRealmId) {
            ((HasRealmId)((Object)this.store)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.store;
    }

    private DefaultModelCriteria<Policy> forRealmAndResourceServer(RealmModel realm, ResourceServer resourceServer) {
        DefaultModelCriteria mcb = (DefaultModelCriteria)DefaultModelCriteria.criteria().compare(Policy.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return resourceServer == null ? mcb : (DefaultModelCriteria)mcb.compare(Policy.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resourceServer.getId()});
    }

    public Policy create(ResourceServer resourceServer, AbstractPolicyRepresentation representation) {
        LOG.tracef("create(%s, %s, %s)%s", new Object[]{representation.getId(), resourceServer.getId(), resourceServer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        DefaultModelCriteria mcb = (DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{representation.getName()});
        if (this.storeWithRealm(realm).exists(QueryParameters.withCriteria(mcb))) {
            throw new ModelDuplicateException("Policy with name '" + representation.getName() + "' for " + resourceServer.getId() + " already exists");
        }
        String uid = representation.getId();
        MapPolicyEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapPolicyEntity.class);
        entity.setId(uid);
        entity.setType(representation.getType());
        entity.setName(representation.getName());
        entity.setResourceServerId(resourceServer.getId());
        entity.setRealmId(resourceServer.getRealm().getId());
        entity = this.storeWithRealm(realm).create(entity);
        return entity == null ? null : this.entityToAdapterFunc(realm, resourceServer).apply(entity);
    }

    public void delete(RealmModel realm, String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        Policy policyEntity = this.findById(realm, null, id);
        if (policyEntity == null) {
            return;
        }
        this.storeWithRealm(realm).delete(id);
    }

    public Policy findById(RealmModel realm, ResourceServer resourceServer, String id) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServer, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).findFirst().map(this.entityToAdapterFunc(realm, resourceServer)).orElse(null);
    }

    public Policy findByName(ResourceServer resourceServer, String name) {
        LOG.tracef("findByName(%s, %s)%s", (Object)name, (Object)resourceServer, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name}))).findFirst().map(this.entityToAdapterFunc(realm, resourceServer)).orElse(null);
    }

    public List<Policy> findByResourceServer(ResourceServer resourceServer) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServer, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(this.forRealmAndResourceServer(realm, resourceServer))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public List<Policy> find(RealmModel realm, ResourceServer resourceServer, Map<Policy.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        LOG.tracef("findByResourceServer(%s, %s, %d, %d)%s", new Object[]{attributes, resourceServer, firstResult, maxResults, StackUtil.getShortStackTrace()});
        DefaultModelCriteria mcb = (DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).filter(Objects::nonNull).toArray(DefaultModelCriteria[]::new));
        if (!attributes.containsKey(Policy.FilterOption.OWNER) && !attributes.containsKey(Policy.FilterOption.ANY_OWNER)) {
            mcb = (DefaultModelCriteria)mcb.compare(Policy.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, Policy.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    private DefaultModelCriteria<Policy> filterEntryToDefaultModelCriteria(Map.Entry<Policy.FilterOption, String[]> entry) {
        Policy.FilterOption name = entry.getKey();
        String[] value = entry.getValue();
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case RESOURCE_ID: 
            case OWNER: {
                return (DefaultModelCriteria)mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList(value)});
            }
            case PERMISSION: {
                mcb = (DefaultModelCriteria)mcb.compare(Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList("resource", "scope", "uma")});
                if (!Boolean.parseBoolean(value[0])) {
                    mcb = DefaultModelCriteria.criteria().not(mcb);
                }
                return mcb;
            }
            case ANY_OWNER: {
                return null;
            }
            case CONFIG: {
                if (value.length != 2) {
                    throw new IllegalArgumentException("Config filter option requires value with two items: [config_name, expected_config_value]");
                }
                value[1] = "%" + value[1] + "%";
                return (DefaultModelCriteria)mcb.compare(Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.LIKE, (Object[])value);
            }
            case TYPE: 
            case NAME: {
                return (DefaultModelCriteria)mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + value[0] + "%"});
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public void findByResource(ResourceServer resourceServer, Resource resource, Consumer<Policy> consumer) {
        LOG.tracef("findByResource(%s, %s, %s)%s", new Object[]{resourceServer, resource, consumer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        this.storeWithRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource.getId()}))).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(consumer);
    }

    public void findByResourceType(ResourceServer resourceServer, String type, Consumer<Policy> policyConsumer) {
        LOG.tracef("findByResourceType(%s, %s)%s", (Object)resourceServer, (Object)type, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        this.storeWithRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.LIKE, (Object[])new String[]{"defaultResourceType", type}))).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(policyConsumer);
    }

    public List<Policy> findByScopes(ResourceServer resourceServer, List<Scope> scopes) {
        LOG.tracef("findByScopes(%s, %s)%s", (Object)resourceServer, scopes, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{scopes.stream().map(Scope::getId)}))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public void findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes, Consumer<Policy> consumer) {
        LOG.tracef("findByResourceType(%s, %s, %s)%s", new Object[]{resourceServer, resource, scopes, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        DefaultModelCriteria mcb = (DefaultModelCriteria)((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{"scope"})).compare(Policy.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{scopes.stream().map(Scope::getId)});
        mcb = resource != null ? (DefaultModelCriteria)mcb.compare(Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource.getId()}) : (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0])).compare(Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.NOT_EXISTS, (Object[])new String[]{"defaultResourceType"});
        this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(consumer);
    }

    public List<Policy> findByType(ResourceServer resourceServer, String type) {
        LOG.tracef("findByType(%s, %s)%s", (Object)resourceServer, (Object)type, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type}))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public List<Policy> findDependentPolicies(ResourceServer resourceServer, String id) {
        RealmModel realm = resourceServer.getRealm();
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Policy.SearchableFields.ASSOCIATED_POLICY_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(Policy.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.storeWithRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void preRemove(RealmModel realm, ResourceServer resourceServer) {
        LOG.tracef("preRemove(%s, %s)%s", (Object)realm, (Object)resourceServer, StackUtil.getShortStackTrace());
        this.storeWithRealm(realm).delete(QueryParameters.withCriteria(this.forRealmAndResourceServer(resourceServer.getRealm(), resourceServer)));
    }
}

