/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.authorization.PathConfigMatcher;
import org.keycloak.adapters.authorization.TokenPrincipal;
import org.keycloak.adapters.authorization.cip.spi.ClaimInformationPointProviderFactory;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.adapters.authorization.spi.HttpResponse;
import org.keycloak.adapters.authorization.util.JsonUtils;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthorizationContext;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.common.util.Base64;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.util.JsonSerialization;

public class PolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(PolicyEnforcer.class);
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private final AuthzClient authzClient;
    private final Map<String, PolicyEnforcerConfig.PathConfig> paths;
    private final PathConfigMatcher pathMatcher;
    private final HttpClient httpClient;
    private final PolicyEnforcerConfig enforcerConfig;
    private final Map<String, ClaimInformationPointProviderFactory> claimInformationPointProviderFactories = new HashMap<String, ClaimInformationPointProviderFactory>();

    public static Builder builder() {
        return new Builder();
    }

    protected PolicyEnforcer(Builder builder) {
        this.enforcerConfig = builder.getEnforcerConfig();
        Configuration authzClientConfig = builder.authzClientConfig;
        if (authzClientConfig.getRealm() == null) {
            authzClientConfig.setRealm(this.enforcerConfig.getRealm());
        }
        if (authzClientConfig.getAuthServerUrl() == null) {
            authzClientConfig.setAuthServerUrl(this.enforcerConfig.getAuthServerUrl());
        }
        if (authzClientConfig.getCredentials() == null || authzClientConfig.getCredentials().isEmpty()) {
            authzClientConfig.setCredentials(this.enforcerConfig.getCredentials());
        }
        if (authzClientConfig.getResource() == null) {
            authzClientConfig.setResource(this.enforcerConfig.getResource());
        }
        this.authzClient = AuthzClient.create((Configuration)authzClientConfig);
        this.httpClient = this.authzClient.getConfiguration().getHttpClient();
        this.pathMatcher = new PathConfigMatcher(builder.getEnforcerConfig(), this.authzClient);
        this.paths = this.pathMatcher.getPathConfig();
        this.loadClaimInformationPointProviders(ServiceLoader.load(ClaimInformationPointProviderFactory.class, ClaimInformationPointProviderFactory.class.getClassLoader()));
        this.loadClaimInformationPointProviders(ServiceLoader.load(ClaimInformationPointProviderFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    public AuthorizationContext enforce(HttpRequest request, HttpResponse response) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement is enabled. Enforcing policy decisions for path [{0}].", (Object)request.getURI());
        }
        AuthorizationContext context = this.authorize(request, response);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Policy enforcement result for path [{0}] is : {1}", (Object)request.getURI(), (Object)(context.isGranted() ? "GRANTED" : "DENIED"));
            LOGGER.debugv("Returning authorization context with permissions:", new Object[0]);
            for (Permission permission : context.getPermissions()) {
                LOGGER.debug((Object)permission);
            }
        }
        return context;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public AuthzClient getAuthzClient() {
        return this.authzClient;
    }

    public Map<String, PolicyEnforcerConfig.PathConfig> getPaths() {
        return Collections.unmodifiableMap(this.paths);
    }

    public Map<String, ClaimInformationPointProviderFactory> getClaimInformationPointProviderFactories() {
        return this.claimInformationPointProviderFactories;
    }

    public PathConfigMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    private AuthorizationContext authorize(HttpRequest request, HttpResponse response) {
        boolean anonymous;
        PolicyEnforcerConfig.EnforcementMode enforcementMode = this.enforcerConfig.getEnforcementMode();
        TokenPrincipal principal = request.getPrincipal();
        boolean bl = anonymous = principal == null || principal.getRawToken() == null;
        if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)enforcementMode)) {
            if (anonymous) {
                response.sendError(401, "Invalid bearer");
            }
            return this.createEmptyAuthorizationContext(true);
        }
        PolicyEnforcerConfig.PathConfig pathConfig = this.getPathConfig(request);
        if (anonymous) {
            if (!this.isDefaultAccessDeniedUri(request)) {
                if (pathConfig != null) {
                    if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) {
                        return this.createEmptyAuthorizationContext(true);
                    }
                    this.challenge(pathConfig, this.getRequiredScopes(pathConfig, request), request, response);
                } else {
                    this.handleAccessDenied(response);
                }
            }
            return this.createEmptyAuthorizationContext(false);
        }
        AccessToken accessToken = principal.getToken();
        if (accessToken != null) {
            Map<String, List<String>> claims;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Checking permissions for path [%s] with config [%s].", (Object)request.getURI(), (Object)pathConfig);
            }
            if (pathConfig == null) {
                if (PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)enforcementMode)) {
                    return this.createAuthorizationContext(accessToken, null);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Could not find a configuration for path [%s]", (Object)this.getPath(request));
                }
                if (this.isDefaultAccessDeniedUri(request)) {
                    return this.createAuthorizationContext(accessToken, null);
                }
                this.handleAccessDenied(response);
                return this.createEmptyAuthorizationContext(false);
            }
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) {
                return this.createAuthorizationContext(accessToken, pathConfig);
            }
            PolicyEnforcerConfig.MethodConfig methodConfig = this.getRequiredScopes(pathConfig, request);
            if (this.isAuthorized(pathConfig, methodConfig, accessToken, request, claims = this.resolveClaims(pathConfig, request))) {
                try {
                    return this.createAuthorizationContext(accessToken, pathConfig);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error processing path [" + pathConfig.getPath() + "].", e);
                }
            }
            AccessToken original = accessToken;
            accessToken = this.requestAuthorizationToken(pathConfig, methodConfig, request, claims);
            if (accessToken != null) {
                AccessToken.Authorization newAuthorization;
                AccessToken.Authorization authorization = original.getAuthorization();
                if (authorization == null) {
                    authorization = new AccessToken.Authorization();
                    authorization.setPermissions(new ArrayList());
                }
                if ((newAuthorization = accessToken.getAuthorization()) != null) {
                    Collection grantedPermissions = authorization.getPermissions();
                    Collection newPermissions = newAuthorization.getPermissions();
                    for (Permission newPermission : newPermissions) {
                        if (grantedPermissions.contains(newPermission)) continue;
                        grantedPermissions.add(newPermission);
                    }
                }
                original.setAuthorization(authorization);
                if (this.isAuthorized(pathConfig, methodConfig, accessToken, request, claims)) {
                    try {
                        return this.createAuthorizationContext(accessToken, pathConfig);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error processing path [" + pathConfig.getPath() + "].", e);
                    }
                }
            }
            if (methodConfig != null && PolicyEnforcerConfig.ScopeEnforcementMode.DISABLED.equals((Object)methodConfig.getScopesEnforcementMode())) {
                return this.createEmptyAuthorizationContext(true);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Sending challenge to the client. Path [%s]", (Object)pathConfig);
            }
            if (!this.challenge(pathConfig, methodConfig, request, response)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Challenge not sent, sending default forbidden response. Path [%s]", (Object)pathConfig);
                }
                this.handleAccessDenied(response);
            }
        }
        return this.createEmptyAuthorizationContext(false);
    }

    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig actualPathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AccessToken accessToken, HttpRequest request, Map<String, List<String>> claims) {
        if (this.isDefaultAccessDeniedUri(request)) {
            return true;
        }
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        boolean hasPermission = false;
        Collection grantedPermissions = authorization.getPermissions();
        for (Permission permission : grantedPermissions) {
            if (permission.getResourceId() != null) {
                if (!this.isResourcePermission(actualPathConfig, permission)) continue;
                hasPermission = true;
                if (actualPathConfig.isInstance() && !this.matchResourcePermission(actualPathConfig, permission) || !this.hasResourceScopePermission(methodConfig, permission)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Authorization GRANTED for path [%s]. Permissions [%s].", (Object)actualPathConfig, (Object)grantedPermissions);
                }
                if (HTTP_METHOD_DELETE.equalsIgnoreCase(request.getMethod()) && actualPathConfig.isInstance()) {
                    this.pathMatcher.removeFromCache(this.getPath(request));
                }
                return this.hasValidClaims(permission, claims);
            }
            if (!this.hasResourceScopePermission(methodConfig, permission)) continue;
            return true;
        }
        if (!hasPermission && PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)actualPathConfig.getEnforcementMode())) {
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Authorization FAILED for path [%s]. Not enough permissions [%s].", (Object)actualPathConfig, (Object)grantedPermissions);
        }
        return false;
    }

    protected Map<String, List<String>> resolveClaims(PolicyEnforcerConfig.PathConfig pathConfig, HttpRequest request) {
        HashMap<String, List<String>> claims = new HashMap<String, List<String>>();
        this.resolveClaims(claims, this.enforcerConfig.getClaimInformationPointConfig(), request);
        this.resolveClaims(claims, pathConfig.getClaimInformationPointConfig(), request);
        return claims;
    }

    protected boolean challenge(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, HttpRequest request, HttpResponse response) {
        if (this.isBearerAuthorization(request)) {
            String ticket = this.getPermissionTicket(pathConfig, methodConfig, this.authzClient, request);
            if (ticket != null) {
                response.setHeader("WWW-Authenticate", "UMA realm=\"" + this.authzClient.getConfiguration().getRealm() + "\"" + ",as_uri=\"" + this.authzClient.getServerConfiguration().getIssuer() + "\"" + ",ticket=\"" + ticket + "\"");
                response.sendError(401);
            } else {
                response.sendError(403);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Sending challenge");
            }
            return true;
        }
        this.handleAccessDenied(response);
        return true;
    }

    protected void handleAccessDenied(HttpResponse response) {
        String accessDeniedPath = this.enforcerConfig.getOnDenyRedirectTo();
        if (accessDeniedPath != null) {
            response.setHeader("Location", accessDeniedPath);
            response.sendError(302);
        } else {
            response.sendError(403);
        }
    }

    private boolean hasValidClaims(Permission permission, Map<String, List<String>> claims) {
        Map grantedClaims = permission.getClaims();
        if (grantedClaims != null) {
            if (claims.isEmpty()) {
                return false;
            }
            for (Map.Entry entry : grantedClaims.entrySet()) {
                List<String> requestClaims = claims.get(entry.getKey());
                if (requestClaims != null && !requestClaims.isEmpty() && ((Set)entry.getValue()).containsAll(requestClaims)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isDefaultAccessDeniedUri(HttpRequest request) {
        String accessDeniedPath = this.enforcerConfig.getOnDenyRedirectTo();
        return accessDeniedPath != null && request.getURI().contains(accessDeniedPath);
    }

    private boolean hasResourceScopePermission(PolicyEnforcerConfig.MethodConfig methodConfig, Permission permission) {
        List requiredScopes = methodConfig.getScopes();
        Set allowedScopes = permission.getScopes();
        if (allowedScopes.isEmpty()) {
            return true;
        }
        PolicyEnforcerConfig.ScopeEnforcementMode enforcementMode = methodConfig.getScopesEnforcementMode();
        if (PolicyEnforcerConfig.ScopeEnforcementMode.ALL.equals((Object)enforcementMode)) {
            return allowedScopes.containsAll(requiredScopes);
        }
        if (PolicyEnforcerConfig.ScopeEnforcementMode.ANY.equals((Object)enforcementMode)) {
            for (String requiredScope : requiredScopes) {
                if (!allowedScopes.contains(requiredScope)) continue;
                return true;
            }
        }
        return requiredScopes.isEmpty();
    }

    private AuthorizationContext createEmptyAuthorizationContext(final boolean granted) {
        return new ClientAuthorizationContext(this.authzClient){

            public boolean hasPermission(String resourceName, String scopeName) {
                return granted;
            }

            public boolean hasResourcePermission(String resourceName) {
                return granted;
            }

            public boolean hasScopePermission(String scopeName) {
                return granted;
            }

            public List<Permission> getPermissions() {
                return Collections.EMPTY_LIST;
            }

            public boolean isGranted() {
                return granted;
            }
        };
    }

    private String getPath(HttpRequest request) {
        return request.getRelativePath();
    }

    private PolicyEnforcerConfig.MethodConfig getRequiredScopes(PolicyEnforcerConfig.PathConfig pathConfig, HttpRequest request) {
        String method = request.getMethod();
        for (PolicyEnforcerConfig.MethodConfig methodConfig : pathConfig.getMethods()) {
            if (!methodConfig.getMethod().equals(method)) continue;
            return methodConfig;
        }
        PolicyEnforcerConfig.MethodConfig methodConfig = new PolicyEnforcerConfig.MethodConfig();
        methodConfig.setMethod(request.getMethod());
        ArrayList<String> scopes = new ArrayList<String>();
        if (Boolean.TRUE.equals(this.enforcerConfig.getHttpMethodAsScope())) {
            scopes.add(request.getMethod());
        } else {
            scopes.addAll(pathConfig.getScopes());
        }
        methodConfig.setScopes(scopes);
        methodConfig.setScopesEnforcementMode(PolicyEnforcerConfig.ScopeEnforcementMode.ANY);
        return methodConfig;
    }

    private AuthorizationContext createAuthorizationContext(AccessToken accessToken, PolicyEnforcerConfig.PathConfig pathConfig) {
        return new ClientAuthorizationContext(accessToken, pathConfig, this.authzClient);
    }

    private boolean isResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        boolean resourceMatch = this.matchResourcePermission(actualPathConfig, permission);
        if (!resourceMatch && actualPathConfig.isInstance()) {
            resourceMatch = this.matchResourcePermission(actualPathConfig.getParentConfig(), permission);
        }
        return resourceMatch;
    }

    private boolean matchResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        return permission.getResourceId().equals(actualPathConfig.getId());
    }

    private PolicyEnforcerConfig.PathConfig getPathConfig(HttpRequest request) {
        return this.isDefaultAccessDeniedUri(request) ? null : this.pathMatcher.matches(this.getPath(request));
    }

    private AccessToken requestAuthorizationToken(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, HttpRequest request, Map<String, List<String>> claims) {
        if (this.enforcerConfig.getUserManagedAccess() != null) {
            return null;
        }
        try {
            AuthorizationResponse authzResponse;
            TokenPrincipal principal = request.getPrincipal();
            String accessTokenString = principal.getRawToken();
            AccessToken accessToken = principal.getToken();
            AuthorizationRequest authzRequest = new AuthorizationRequest();
            if (this.isBearerAuthorization(request) || accessToken.getAuthorization() != null) {
                authzRequest.addPermission(pathConfig.getId(), methodConfig.getScopes());
            }
            if (!claims.isEmpty()) {
                authzRequest.setClaimTokenFormat("urn:ietf:params:oauth:token-type:jwt");
                authzRequest.setClaimToken(Base64.encodeBytes((byte[])JsonSerialization.writeValueAsBytes(claims)));
            }
            if (accessToken.getAuthorization() != null) {
                authzRequest.setRpt(accessTokenString);
            }
            LOGGER.debug((Object)"Obtaining authorization for authenticated user.");
            if (this.isBearerAuthorization(request)) {
                authzRequest.setSubjectToken(accessTokenString);
                authzResponse = this.authzClient.authorization().authorize(authzRequest);
            } else {
                authzResponse = this.authzClient.authorization(accessTokenString).authorize(authzRequest);
            }
            if (authzResponse != null) {
                return JsonUtils.asAccessToken(authzResponse.getToken());
            }
        }
        catch (AuthorizationDeniedException ignore) {
            LOGGER.debug((Object)"Authorization denied", (Throwable)ignore);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Authorization failed", (Throwable)e);
        }
        return null;
    }

    private String getPermissionTicket(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AuthzClient authzClient, HttpRequest httpFacade) {
        if (this.enforcerConfig.getUserManagedAccess() != null) {
            ProtectionResource protection = authzClient.protection();
            PermissionResource permission = protection.permission();
            PermissionRequest permissionRequest = new PermissionRequest();
            permissionRequest.setResourceId(pathConfig.getId());
            permissionRequest.setScopes(new HashSet(methodConfig.getScopes()));
            Map<String, List<String>> claims = this.resolveClaims(pathConfig, httpFacade);
            if (!claims.isEmpty()) {
                permissionRequest.setClaims(claims);
            }
            return permission.create(permissionRequest).getTicket();
        }
        return null;
    }

    private boolean isBearerAuthorization(HttpRequest request) {
        List<String> authHeaders = request.getHeaders("Authorization");
        if (authHeaders != null) {
            for (String authHeader : authHeaders) {
                String[] split = authHeader.trim().split("\\s+");
                if (split == null || split.length != 2 || !split[0].equalsIgnoreCase("Bearer")) continue;
                return true;
            }
        }
        return this.authzClient.getConfiguration().isBearerOnly();
    }

    private void loadClaimInformationPointProviders(ServiceLoader<ClaimInformationPointProviderFactory> loader) {
        for (ClaimInformationPointProviderFactory factory : loader) {
            factory.init(this);
            this.claimInformationPointProviderFactories.put(factory.getName(), factory);
        }
    }

    private void resolveClaims(Map<String, List<String>> claims, Map<String, Map<String, Object>> claimInformationPointConfig, HttpRequest request) {
        if (claimInformationPointConfig != null) {
            for (Map.Entry<String, Map<String, Object>> claimDef : claimInformationPointConfig.entrySet()) {
                ClaimInformationPointProviderFactory factory = this.claimInformationPointProviderFactories.get(claimDef.getKey());
                if (factory == null) continue;
                claims.putAll(factory.create(claimDef.getValue()).resolve(request));
            }
        }
    }

    public static class Builder {
        Configuration authzClientConfig = new Configuration();

        private Builder() {
        }

        public Builder authServerUrl(String authServerUrl) {
            this.authzClientConfig.setAuthServerUrl(authServerUrl);
            return this;
        }

        public Builder realm(String realm) {
            this.authzClientConfig.setRealm(realm);
            return this;
        }

        public Builder clientId(String clientId) {
            this.authzClientConfig.setResource(clientId);
            return this;
        }

        public Builder bearerOnly(boolean bearerOnly) {
            this.authzClientConfig.setBearerOnly(bearerOnly);
            return this;
        }

        public Builder credentials(Map<String, Object> credentials) {
            this.authzClientConfig.setCredentials(credentials);
            return this;
        }

        public Builder enforcerConfig(PolicyEnforcerConfig enforcerConfig) {
            this.authzClientConfig.setPolicyEnforcerConfig(enforcerConfig);
            return this;
        }

        public Builder enforcerConfig(InputStream is) {
            try {
                this.enforcerConfig((PolicyEnforcerConfig)JsonSerialization.readValue((InputStream)is, PolicyEnforcerConfig.class));
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to read configuration", cause);
            }
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.authzClientConfig.setHttpClient(httpClient);
            return this;
        }

        public Builder credentialProvider(ClientCredentialsProvider credentialsProvider) {
            this.authzClientConfig.setClientCredentialsProvider(credentialsProvider);
            return this;
        }

        public PolicyEnforcer build() {
            return new PolicyEnforcer(this);
        }

        PolicyEnforcerConfig getEnforcerConfig() {
            return this.authzClientConfig.getPolicyEnforcerConfig();
        }
    }
}

