/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.smallrye.config.ConfigValue;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;
import org.keycloak.config.DeprecatedMetadata;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Help;
import org.keycloak.quarkus.runtime.cli.HelpFactory;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.PropertyMapperParameterConsumer;
import org.keycloak.quarkus.runtime.cli.ShortErrorMessageHandler;
import org.keycloak.quarkus.runtime.cli.SubCommandListRenderer;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.Main;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.PropertyMappingInterceptor;
import org.keycloak.quarkus.runtime.configuration.QuarkusPropertiesConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public final class Picocli {
    public static final String ARG_PREFIX = "--";
    public static final String ARG_SHORT_PREFIX = "-";
    public static final String NO_PARAM_LABEL = "none";
    private static final String ARG_KEY_VALUE_SEPARATOR = "=";

    private Picocli() {
    }

    public static void parseAndRun(List<String> cliArgs) {
        CommandLine cmd = Picocli.createCommandLine(cliArgs);
        String[] argArray = cliArgs.toArray(new String[0]);
        if (Environment.isRebuildCheck()) {
            int exitCode = 0;
            try {
                cmd.parseArgs(argArray);
                exitCode = Picocli.runReAugmentationIfNeeded(cliArgs, cmd);
            }
            catch (CommandLine.ParameterException ex) {
                try {
                    exitCode = cmd.getParameterExceptionHandler().handleParseException(ex, argArray);
                }
                catch (Exception e) {
                    ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
                    errorHandler.error(cmd.getErr(), e.getMessage(), null);
                    exitCode = ex.getCommandLine().getCommandSpec().exitCodeOnInvalidInput();
                }
            }
            Picocli.exitOnFailure(exitCode, cmd);
            return;
        }
        int exitCode = cmd.execute(argArray);
        Picocli.exitOnFailure(exitCode, cmd);
    }

    private static void exitOnFailure(int exitCode, CommandLine cmd) {
        if (exitCode != cmd.getCommandSpec().exitCodeOnSuccess() && !Environment.isTestLaunchMode() || Environment.isRebuildCheck()) {
            System.exit(exitCode);
        }
    }

    private static int runReAugmentationIfNeeded(List<String> cliArgs, CommandLine cmd) {
        String profile;
        int exitCode = 0;
        CommandLine currentCommandSpec = Picocli.getCurrentCommandSpec(cliArgs, cmd.getCommandSpec());
        if (currentCommandSpec == null) {
            return exitCode;
        }
        String currentCommandName = currentCommandSpec.getCommandName();
        if (Picocli.shouldSkipRebuild(cliArgs, currentCommandName)) {
            return exitCode;
        }
        if (currentCommandName.equals("start-dev") && (profile = Environment.getProfile()) == null) {
            Environment.forceDevProfile();
        }
        if (Picocli.requiresReAugmentation(currentCommandSpec)) {
            exitCode = Picocli.runReAugmentation(cliArgs, cmd);
        }
        return exitCode;
    }

    private static boolean shouldSkipRebuild(List<String> cliArgs, String currentCommandName) {
        return cliArgs.contains("--help") || cliArgs.contains("-h") || cliArgs.contains("--help-all") || currentCommandName.equals("build") || currentCommandName.equals("show-config") || currentCommandName.equals("tools");
    }

    private static boolean requiresReAugmentation(CommandLine cmdCommand) {
        if (Picocli.hasConfigChanges(cmdCommand)) {
            return ConfigArgsConfigSource.getAllCliArgs().contains("start-dev") || !"dev".equals(Configuration.getConfig().getOptionalValue("kc.profile", String.class).orElse(null));
        }
        return Picocli.hasProviderChanges();
    }

    private static List<String> getSanitizedRuntimeCliOptions() {
        final ArrayList<String> properties = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(ConfigArgsConfigSource.getAllCliArgs(), new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                PropertyMapper<?> mapper = PropertyMappers.getMapper(key);
                if (mapper != null && mapper.isBuildTime()) {
                    return;
                }
                properties.add(key + Picocli.ARG_KEY_VALUE_SEPARATOR + PropertyMappers.formatValue(key, value));
            }
        }, arg -> properties.add((String)arg));
        return properties;
    }

    private static int runReAugmentation(List<String> cliArgs, CommandLine cmd) {
        if (!Environment.isDevMode() && cmd != null) {
            cmd.getOut().println("Changes detected in configuration. Updating the server image.");
            Picocli.checkChangesInBuildOptionsDuringAutoBuild();
        }
        ArrayList<String> configArgsList = new ArrayList<String>(cliArgs);
        String commandName = Picocli.getCurrentCommandSpec(cliArgs, cmd.getCommandSpec()).getCommandName();
        configArgsList.replaceAll(arg -> Picocli.replaceCommandWithBuild(commandName, arg));
        configArgsList.removeIf(Picocli::isRuntimeOption);
        int exitCode = cmd.execute(configArgsList.toArray(new String[0]));
        if (!Environment.isDevMode() && exitCode == cmd.getCommandSpec().exitCodeOnSuccess()) {
            cmd.getOut().printf("Next time you run the server, just run:%n%n\t%s %s %s%n%n", Environment.getCommand(), String.join((CharSequence)" ", Picocli.getSanitizedRuntimeCliOptions()), "--optimized");
        }
        return exitCode;
    }

    private static boolean hasProviderChanges() {
        Map persistedProps = PersistedConfigSource.getInstance().getProperties();
        Map<String, File> deployedProviders = Environment.getProviderFiles();
        if (persistedProps.isEmpty()) {
            return !deployedProviders.isEmpty();
        }
        Set providerKeys = persistedProps.keySet().stream().filter(Picocli::isProviderKey).collect(Collectors.toSet());
        if (deployedProviders.size() != providerKeys.size()) {
            return true;
        }
        for (String key : providerKeys) {
            String fileName = key.substring("kc.provider.file".length() + 1, key.lastIndexOf(46));
            if (!deployedProviders.containsKey(fileName)) {
                return true;
            }
            File file = deployedProviders.get(fileName);
            String lastModified = (String)persistedProps.get(key);
            if (lastModified.equals(String.valueOf(file.lastModified()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateConfig(List<String> cliArgs, AbstractCommand abstractCommand) {
        IncludeOptions options = Picocli.getIncludeOptions(cliArgs, abstractCommand, abstractCommand.getName());
        if (!options.includeBuildTime && !options.includeRuntime) {
            return;
        }
        try {
            PropertyMappingInterceptor.disable();
            ArrayList<String> ignoredBuildTime = new ArrayList<String>();
            ArrayList<String> ignoredRunTime = new ArrayList<String>();
            HashSet deprecatedInUse = new HashSet();
            for (OptionCategory category : abstractCommand.getOptionCategories()) {
                ArrayList mappers = new ArrayList();
                Optional.ofNullable(PropertyMappers.getRuntimeMappers().get(category)).ifPresent(mappers::addAll);
                Optional.ofNullable(PropertyMappers.getBuildTimeMappers().get(category)).ifPresent(mappers::addAll);
                for (PropertyMapper mapper : mappers) {
                    ConfigValue configValue = Configuration.getConfigValue(mapper.getFrom());
                    String configValueStr = configValue.getValue();
                    if (configValueStr == null || configValue.getConfigSourceOrdinal() < 300) continue;
                    if (mapper.isBuildTime() && !options.includeBuildTime) {
                        ignoredBuildTime.add(mapper.getFrom());
                        continue;
                    }
                    if (mapper.isRunTime() && !options.includeRuntime) {
                        ignoredRunTime.add(mapper.getFrom());
                        continue;
                    }
                    mapper.validate(configValue);
                    mapper.getDeprecatedMetadata().ifPresent(metadata -> Picocli.handleDeprecated(deprecatedInUse, mapper, configValueStr, metadata));
                }
            }
            Logger logger = Logger.getLogger(Picocli.class);
            if (!ignoredBuildTime.isEmpty()) {
                Picocli.outputIgnoredProperties(ignoredBuildTime, true, logger);
            } else if (!ignoredRunTime.isEmpty()) {
                Picocli.outputIgnoredProperties(ignoredRunTime, false, logger);
            }
            if (!deprecatedInUse.isEmpty()) {
                logger.warn((Object)("The following used options or option values are DEPRECATED and will be removed in a future release:\n" + String.join((CharSequence)"\n", deprecatedInUse)));
            }
        }
        finally {
            PropertyMappingInterceptor.enable();
        }
    }

    private static void handleDeprecated(Set<String> deprecatedInUse, PropertyMapper<?> mapper, String configValue, DeprecatedMetadata metadata) {
        String optionName;
        HashSet<String> deprecatedValuesInUse = new HashSet<String>();
        if (!metadata.getDeprecatedValues().isEmpty()) {
            deprecatedValuesInUse.addAll(Arrays.asList(configValue.split(",")));
            deprecatedValuesInUse.retainAll(metadata.getDeprecatedValues());
            if (deprecatedValuesInUse.isEmpty()) {
                return;
            }
        }
        if ((optionName = mapper.getFrom()).startsWith("kc.")) {
            optionName = optionName.substring("kc.".length());
        }
        StringBuilder sb = new StringBuilder("\t- ");
        sb.append(optionName);
        if (!deprecatedValuesInUse.isEmpty()) {
            sb.append(ARG_KEY_VALUE_SEPARATOR).append(String.join((CharSequence)",", deprecatedValuesInUse));
        }
        if (metadata.getNote() != null || !metadata.getNewOptionsKeys().isEmpty()) {
            sb.append(":");
        }
        if (metadata.getNote() != null) {
            sb.append(" ");
            sb.append(metadata.getNote());
            if (!metadata.getNote().endsWith(".")) {
                sb.append(".");
            }
        }
        if (!metadata.getNewOptionsKeys().isEmpty()) {
            sb.append(" Use ");
            sb.append(String.join((CharSequence)", ", metadata.getNewOptionsKeys()));
            sb.append(".");
        }
        deprecatedInUse.add(sb.toString());
    }

    private static void outputIgnoredProperties(List<String> properties, boolean build, Logger logger) {
        logger.warn((Object)String.format("The following %s time non-cli options were found, but will be ignored during %s time: %s\n", build ? "build" : "run", build ? "run" : "build", properties.stream().collect(Collectors.joining(", "))));
    }

    private static boolean hasConfigChanges(CommandLine cmdCommand) {
        Optional persistedConfigSource;
        Map<String, String> foundQuarkusBuildProperties;
        Optional quarkusPropertiesConfigSource;
        Optional<String> currentProfile = Optional.ofNullable(Environment.getProfile());
        Optional<String> persistedProfile = Configuration.getBuildTimeProperty("kc.profile");
        if (!persistedProfile.orElse("").equals(currentProfile.orElse(""))) {
            return true;
        }
        for (String propertyName : Configuration.getConfig().getPropertyNames()) {
            ConfigValue configValue;
            if (!PropertyMappers.isBuildTimeProperty(propertyName) || (configValue = Configuration.getConfig().getConfigValue(propertyName)) == null || configValue.getConfigSourceName() == null) continue;
            if (propertyName.startsWith("%")) {
                propertyName = propertyName.substring(propertyName.indexOf(46) + 1);
            }
            String persistedValue = Configuration.getBuildTimeProperty(propertyName).orElse("");
            String runtimeValue = Configuration.getRuntimeProperty(propertyName).orElse(null);
            if (cmdCommand.getCommand() instanceof AbstractCommand) {
                AbstractCommand abstractCommand = (AbstractCommand)cmdCommand.getCommand();
                PropertyMapper<?> mapper = PropertyMappers.getMapper(propertyName);
                if (mapper != null && !abstractCommand.getOptionCategories().contains(mapper.getCategory())) continue;
            }
            if (runtimeValue == null && StringUtil.isNotBlank((String)persistedValue)) {
                PropertyMapper<?> mapper = PropertyMappers.getMapper(propertyName);
                if (mapper != null && persistedValue.equals(Option.getDefaultValueString(mapper.getDefaultValue().orElse(null)))) continue;
                return true;
            }
            if (persistedValue.equals(runtimeValue)) continue;
            return true;
        }
        if (QuarkusPropertiesConfigSource.getConfigurationFile() != null && (quarkusPropertiesConfigSource = Configuration.getConfig().getConfigSource("QuarkusProperties")).isPresent() && !(foundQuarkusBuildProperties = Picocli.findSupportedRawQuarkusBuildProperties(((ConfigSource)quarkusPropertiesConfigSource.get()).getProperties().entrySet())).isEmpty() && (persistedConfigSource = Configuration.getConfig().getConfigSource("PersistedConfigSource")).isPresent()) {
            for (String key : foundQuarkusBuildProperties.keySet()) {
                if (!Picocli.notContainsKey((ConfigSource)persistedConfigSource.get(), key)) continue;
                return true;
            }
            return Picocli.hasAtLeastOneChangedBuildProperty(foundQuarkusBuildProperties, ((ConfigSource)persistedConfigSource.get()).getProperties().entrySet());
        }
        return false;
    }

    private static boolean hasAtLeastOneChangedBuildProperty(Map<String, String> foundQuarkusBuildProperties, Set<Map.Entry<String, String>> persistedEntries) {
        for (Map.Entry<String, String> persistedEntry : persistedEntries) {
            if (!foundQuarkusBuildProperties.containsKey(persistedEntry.getKey())) continue;
            return Picocli.isChangedValue(foundQuarkusBuildProperties, persistedEntry);
        }
        return false;
    }

    private static boolean notContainsKey(ConfigSource persistedConfigSource, String key) {
        return !persistedConfigSource.getProperties().containsKey(key);
    }

    private static Map<String, String> findSupportedRawQuarkusBuildProperties(Set<Map.Entry<String, String>> entries) {
        Pattern buildTimePattern = Pattern.compile("^quarkus\\.datasource\\.[A-Za-z0-9\\-_]+\\.(db-kind|jdbc\\.driver|jdbc\\.transactions|jdbc\\.enable-metrics)$");
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries) {
            if (!buildTimePattern.matcher(entry.getKey()).matches()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static boolean isChangedValue(Map<String, String> foundQuarkusBuildProps, Map.Entry<String, String> persistedEntry) {
        return !foundQuarkusBuildProps.get(persistedEntry.getKey()).equals(persistedEntry.getValue());
    }

    private static boolean isProviderKey(String key) {
        return key.startsWith("kc.provider.file");
    }

    public static CommandLine createCommandLine(List<String> cliArgs) {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new Main()).name(Environment.getCommand());
        for (CommandLine subCommand : spec.subcommands().values()) {
            CommandLine.Model.CommandSpec subCommandSpec = subCommand.getCommandSpec();
            subCommandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String[])Help.OPTION_NAMES).usageHelp(true).description(new String[]{"This help message."})).build());
        }
        Picocli.addCommandOptions(cliArgs, Picocli.getCurrentCommandSpec(cliArgs, spec));
        if (Environment.isRebuildCheck()) {
            Picocli.addCommandOptions(cliArgs, (CommandLine)spec.subcommands().get("build"));
        }
        CommandLine cmd = new CommandLine((Object)spec);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExecutionExceptionHandler());
        cmd.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new ShortErrorMessageHandler());
        cmd.setHelpFactory((CommandLine.IHelpFactory)new HelpFactory());
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setErr(new PrintWriter(System.err, true));
        return cmd;
    }

    private static IncludeOptions getIncludeOptions(List<String> cliArgs, AbstractCommand abstractCommand, String commandName) {
        IncludeOptions result = new IncludeOptions();
        if (abstractCommand == null) {
            return result;
        }
        result.includeRuntime = abstractCommand.includeRuntime();
        result.includeBuildTime = abstractCommand.includeBuildTime();
        if (!result.includeBuildTime && !result.includeRuntime) {
            return result;
        }
        if (result.includeRuntime && !result.includeBuildTime && !"show-config".equals(commandName)) {
            result.includeBuildTime = Environment.isRebuilt() || !cliArgs.contains("--optimized");
        } else if (result.includeBuildTime && !result.includeRuntime) {
            result.includeRuntime = Environment.isRebuildCheck();
        }
        return result;
    }

    private static void addCommandOptions(List<String> cliArgs, CommandLine command) {
        if (command != null && command.getCommand() instanceof AbstractCommand) {
            IncludeOptions options = Picocli.getIncludeOptions(cliArgs, (AbstractCommand)command.getCommand(), command.getCommandName());
            if (!options.includeBuildTime && !options.includeRuntime) {
                return;
            }
            Picocli.addOptionsToCli(command, options.includeBuildTime, options.includeRuntime);
        }
    }

    private static CommandLine getCurrentCommandSpec(List<String> cliArgs, CommandLine.Model.CommandSpec spec) {
        for (String arg : cliArgs) {
            CommandLine command = (CommandLine)spec.subcommands().get(arg);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    private static void addOptionsToCli(CommandLine commandLine, boolean includeBuildTime, boolean includeRuntime) {
        EnumMap mappers = new EnumMap(OptionCategory.class);
        if (includeRuntime) {
            mappers.putAll(PropertyMappers.getRuntimeMappers());
        }
        if (includeBuildTime) {
            for (Map.Entry<OptionCategory, List<PropertyMapper<?>>> entry : PropertyMappers.getBuildTimeMappers().entrySet()) {
                ArrayList result = new ArrayList(mappers.getOrDefault(entry.getKey(), Collections.emptyList()));
                result.addAll(entry.getValue());
                mappers.put(entry.getKey(), result);
            }
        }
        Picocli.addMappedOptionsToArgGroups(commandLine, mappers);
    }

    private static void addMappedOptionsToArgGroups(CommandLine commandLine, Map<OptionCategory, List<PropertyMapper<?>>> propertyMappers) {
        CommandLine.Model.CommandSpec cSpec = commandLine.getCommandSpec();
        for (OptionCategory category : ((AbstractCommand)commandLine.getCommand()).getOptionCategories()) {
            List<PropertyMapper<?>> mappersInCategory = propertyMappers.get(category);
            if (mappersInCategory == null) continue;
            CommandLine.Model.ArgGroupSpec.Builder argGroupBuilder = CommandLine.Model.ArgGroupSpec.builder().heading(category.getHeading() + ":").order(category.getOrder()).validate(false);
            for (final PropertyMapper<?> mapper : mappersInCategory) {
                String name = mapper.getCliFormat();
                String description = mapper.getDescription();
                if (description == null || cSpec.optionsMap().containsKey(name) || name.endsWith(Configuration.OPTION_PART_SEPARATOR)) continue;
                CommandLine.Model.OptionSpec.Builder optBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).description(new String[]{Picocli.getDecoratedOptionDescription(mapper)})).paramLabel(mapper.getParamLabel())).completionCandidates((Iterable)new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return mapper.getExpectedValues().iterator();
                    }
                })).parameterConsumer(PropertyMapperParameterConsumer.INSTANCE)).hidden(mapper.isHidden());
                if (mapper.getDefaultValue().isPresent()) {
                    optBuilder.defaultValue(Option.getDefaultValueString(mapper.getDefaultValue().get()));
                }
                if (mapper.getType() != null) {
                    optBuilder.type(mapper.getType());
                } else {
                    optBuilder.type(String.class);
                }
                argGroupBuilder.addArg((CommandLine.Model.ArgSpec)optBuilder.build());
            }
            if (argGroupBuilder.args().isEmpty()) continue;
            cSpec.addArgGroup(argGroupBuilder.build());
        }
    }

    private static String getDecoratedOptionDescription(PropertyMapper<?> mapper) {
        StringBuilder transformedDesc = new StringBuilder(mapper.getDescription());
        if (mapper.getType() != Boolean.class && !mapper.getExpectedValues().isEmpty()) {
            List<String> decoratedExpectedValues = mapper.getExpectedValues().stream().map(value -> {
                if (mapper.getDeprecatedMetadata().isPresent() && mapper.getDeprecatedMetadata().get().getDeprecatedValues().contains(value)) {
                    return value + " (deprecated)";
                }
                return value;
            }).toList();
            transformedDesc.append(" Possible values are: " + String.join((CharSequence)", ", decoratedExpectedValues) + ".");
        }
        mapper.getDefaultValue().map(d -> Option.getDefaultValueString((Object)d).replaceAll("%", "%%")).map(d -> " Default: " + d + ".").ifPresent(transformedDesc::append);
        mapper.getDeprecatedMetadata().filter(deprecatedMetadata -> deprecatedMetadata.getDeprecatedValues().isEmpty()).ifPresent(deprecatedMetadata -> {
            ArrayList<Object> deprecatedDetails = new ArrayList<Object>();
            Object note = deprecatedMetadata.getNote();
            if (note != null) {
                if (!((String)note).endsWith(".")) {
                    note = (String)note + ".";
                }
                deprecatedDetails.add(note);
            }
            if (!deprecatedMetadata.getNewOptionsKeys().isEmpty()) {
                String s = deprecatedMetadata.getNewOptionsKeys().size() > 1 ? "s" : "";
                deprecatedDetails.add("Use the following option" + s + " instead: " + String.join((CharSequence)", ", deprecatedMetadata.getNewOptionsKeys()) + ".");
            }
            transformedDesc.insert(0, "@|bold DEPRECATED.|@ ");
            if (!deprecatedDetails.isEmpty()) {
                transformedDesc.append(" @|bold ").append(String.join((CharSequence)" ", deprecatedDetails)).append("|@");
            }
        });
        return transformedDesc.toString();
    }

    public static void println(CommandLine cmd, String message) {
        cmd.getOut().println(message);
    }

    public static List<String> parseArgs(String[] rawArgs) throws PropertyException {
        if (rawArgs.length == 0) {
            return List.of();
        }
        ConfigArgsConfigSource.setCliArgs(rawArgs);
        ArrayList<String> args = new ArrayList<String>(List.of(rawArgs));
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (!arg.startsWith("--spi") && !arg.startsWith("-D")) continue;
            iterator.remove();
            if (arg.contains(ARG_KEY_VALUE_SEPARATOR)) continue;
            if (!iterator.hasNext()) {
                if (arg.startsWith("--spi")) {
                    throw new PropertyException(String.format("spi argument %s requires a value.", arg));
                }
                return args;
            }
            String next = (String)iterator.next();
            if (next.startsWith(ARG_PREFIX)) continue;
            iterator.remove();
        }
        return args;
    }

    private static String replaceCommandWithBuild(String commandName, String arg) {
        if (arg.equals(commandName)) {
            return "build";
        }
        return arg;
    }

    private static boolean isRuntimeOption(String arg) {
        return arg.startsWith("--import-realm");
    }

    private static void checkChangesInBuildOptionsDuringAutoBuild() {
        if (Configuration.isOptimized()) {
            List buildOptions = StreamSupport.stream(Configuration.getPropertyNames(true).spliterator(), false).sorted().map(PropertyMappers::getMapper).filter(Objects::nonNull).collect(Collectors.toList());
            if (buildOptions.isEmpty()) {
                return;
            }
            StringBuilder options = new StringBuilder();
            for (PropertyMapper mapper : buildOptions) {
                String currentValue;
                String newValue = Optional.ofNullable(Configuration.getCurrentBuiltTimeProperty(mapper.getFrom())).map(ConfigValue::getValue).orElse("<unset>");
                if (newValue.equals(currentValue = Configuration.getRawPersistedProperty(mapper.getFrom()).get())) continue;
                String name = mapper.getOption().getKey();
                options.append("\n\t- ").append(name).append(ARG_KEY_VALUE_SEPARATOR).append(currentValue).append(" > ").append(name).append(ARG_KEY_VALUE_SEPARATOR).append(newValue);
            }
            if (options.length() > 0) {
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red " + "The previous optimized build will be overridden with the following build options:" + options + "\nTo avoid that, run the 'build' command again and then start the optimized server instance using the '--optimized' flag." + "|@"));
            }
        }
    }

    private static class IncludeOptions {
        boolean includeRuntime;
        boolean includeBuildTime;

        private IncludeOptions() {
        }
    }
}

