/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.DefaultClientScopes;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo4_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("4.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo4_0_0.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm, false));
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm, true);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm, boolean json) {
        realm.getClientScopesStream().filter(clientScope -> clientScope.getName().contains(" ")).forEach(clientScope -> {
            LOG.debugf("Replacing spaces with underscores in the name of client scope '%s' of realm '%s'", (Object)clientScope.getName(), (Object)realm.getName());
            String replacedName = clientScope.getName().replaceAll(" ", "_");
            clientScope.setName(replacedName);
        });
        if (!json) {
            LOG.debugf("Adding defaultClientScopes for realm '%s'", (Object)realm.getName());
            DefaultClientScopes.createDefaultClientScopes(session, realm, false);
        }
        realm.getComponentsStream(realm.getId(), "org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy").filter(component -> Objects.equals(component.getProviderId(), "allowed-client-templates")).forEach(component -> {
            List configVal = (List)component.getConfig().remove((Object)"allowed-client-templates");
            if (configVal != null) {
                component.getConfig().put((Object)"allowed-client-scopes", (Object)configVal);
            }
            component.put("allow-default-scopes", true);
            realm.updateComponent(component);
        });
        RoleModel offlineAccessRole = realm.getRole("offline_access");
        if (offlineAccessRole == null) {
            LOG.infof("Role 'offline_access' not available in realm '%s'. Skip migration of offline_access client scope.", (Object)realm.getName());
        } else {
            ClientScopeModel offlineAccessScope = KeycloakModelUtils.getClientScopeByName(realm, "offline_access");
            if (offlineAccessScope == null) {
                LOG.infof("Client scope 'offline_access' not available in realm '%s'. Skip migration of offline_access client scope.", (Object)realm.getName());
            } else {
                realm.getClientsStream().filter(MigrationUtils::isOIDCNonBearerOnlyClient).filter(c -> c.hasScope(offlineAccessRole)).filter(c -> !c.getClientScopes(false).containsKey("offline_access")).peek(c -> {
                    LOG.debugf("Adding client scope 'offline_access' as optional scope to client '%s' in realm '%s'.", (Object)c.getClientId(), (Object)realm.getName());
                    c.addClientScope(offlineAccessScope, false);
                }).filter(c -> !c.isFullScopeAllowed()).forEach(c -> {
                    LOG.debugf("Removing role scope mapping for role 'offline_access' from client '%s' in realm '%s'.", (Object)c.getClientId(), (Object)realm.getName());
                    c.deleteScopeMapping(offlineAccessRole);
                });
            }
        }
        realm.getClientsStream().filter(ClientModel::isConsentRequired).filter(c -> c.getClientScopes(true).isEmpty()).forEach(c -> {
            LOG.debugf("Adding client '%s' of realm '%s' to display itself on consent screen", (Object)c.getClientId(), (Object)realm.getName());
            c.setDisplayOnConsentScreen(true);
            String consentText = c.getName() == null ? c.getClientId() : c.getName();
            c.setConsentScreenText(consentText);
        });
    }
}

