/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.Collections;
import java.util.List;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.utils.EmailValidationUtil;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class EmailValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final String ID = "email";
    public static final EmailValidator INSTANCE = new EmailValidator();
    public static final String MESSAGE_INVALID_EMAIL = "error-invalid-email";

    public String getId() {
        return ID;
    }

    @Override
    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (!EmailValidationUtil.isValidEmail(value)) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_EMAIL, value));
        }
    }

    public String getHelpText() {
        return "Email format validator";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }
}

