/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential.hash;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.PaddingUtils;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.credential.PasswordCredentialModel;

public class Pbkdf2PasswordHashProvider
implements PasswordHashProvider {
    private final String providerId;
    private final String pbkdf2Algorithm;
    private final int defaultIterations;
    private final int maxPaddingLength;
    private final int derivedKeySize;
    public static final int DEFAULT_DERIVED_KEY_SIZE = 512;

    public Pbkdf2PasswordHashProvider(String providerId, String pbkdf2Algorithm, int defaultIterations, int minPbkdf2PasswordLengthForPadding) {
        this(providerId, pbkdf2Algorithm, defaultIterations, minPbkdf2PasswordLengthForPadding, 512);
    }

    public Pbkdf2PasswordHashProvider(String providerId, String pbkdf2Algorithm, int defaultIterations, int maxPaddingLength, int derivedKeySize) {
        this.providerId = providerId;
        this.pbkdf2Algorithm = pbkdf2Algorithm;
        this.defaultIterations = defaultIterations;
        this.maxPaddingLength = maxPaddingLength;
        this.derivedKeySize = derivedKeySize;
    }

    public boolean policyCheck(PasswordPolicy policy, PasswordCredentialModel credential) {
        int policyHashIterations = policy.getHashIterations();
        if (policyHashIterations == -1) {
            policyHashIterations = this.defaultIterations;
        }
        return credential.getPasswordCredentialData().getHashIterations() == policyHashIterations && this.providerId.equals(credential.getPasswordCredentialData().getAlgorithm()) && this.derivedKeySize == this.keySize(credential);
    }

    public PasswordCredentialModel encodedCredential(String rawPassword, int iterations) {
        if (iterations == -1) {
            iterations = this.defaultIterations;
        }
        byte[] salt = this.getSalt();
        String encodedPassword = this.encodedCredential(rawPassword, iterations, salt, this.derivedKeySize);
        return PasswordCredentialModel.createFromValues((String)this.providerId, (byte[])salt, (int)iterations, (String)encodedPassword);
    }

    public String encode(String rawPassword, int iterations) {
        if (iterations == -1) {
            iterations = this.defaultIterations;
        }
        byte[] salt = this.getSalt();
        return this.encodedCredential(rawPassword, iterations, salt, this.derivedKeySize);
    }

    public boolean verify(String rawPassword, PasswordCredentialModel credential) {
        return this.encodedCredential(rawPassword, credential.getPasswordCredentialData().getHashIterations(), credential.getPasswordSecretData().getSalt(), this.keySize(credential)).equals(credential.getPasswordSecretData().getValue());
    }

    private int keySize(PasswordCredentialModel credential) {
        try {
            byte[] bytes = Base64.decode((String)credential.getPasswordSecretData().getValue());
            return bytes.length * 8;
        }
        catch (IOException e) {
            throw new RuntimeException("Credential could not be decoded", e);
        }
    }

    public void close() {
    }

    private String encodedCredential(String rawPassword, int iterations, byte[] salt, int derivedKeySize) {
        String rawPasswordWithPadding = PaddingUtils.padding((String)rawPassword, (int)this.maxPaddingLength);
        PBEKeySpec spec = new PBEKeySpec(rawPasswordWithPadding.toCharArray(), salt, iterations, derivedKeySize);
        try {
            byte[] key = this.getSecretKeyFactory().generateSecret(spec).getEncoded();
            return Base64.encodeBytes((byte[])key);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Credential could not be encoded", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getSalt() {
        byte[] buffer = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(buffer);
        return buffer;
    }

    private SecretKeyFactory getSecretKeyFactory() {
        try {
            return CryptoIntegration.getProvider().getSecretKeyFact(this.pbkdf2Algorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException("PBKDF2 algorithm not found", e);
        }
    }
}

