/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleModel;
import org.keycloak.provider.ProviderEvent;

public interface RoleContainerModel {
    public String getId();

    public RoleModel getRole(String var1);

    public RoleModel addRole(String var1);

    public RoleModel addRole(String var1, String var2);

    public boolean removeRole(RoleModel var1);

    public Set<RoleModel> getRoles();

    public Set<RoleModel> getRoles(Integer var1, Integer var2);

    public Set<RoleModel> searchForRoles(String var1, Integer var2, Integer var3);

    public List<String> getDefaultRoles();

    public void addDefaultRole(String var1);

    default public void updateDefaultRoles(String ... defaultRoles) {
        List<String> defaultRolesArray = Arrays.asList(defaultRoles);
        List<String> entities = this.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<String> remove = new ArrayList<String>();
        for (String rel : entities) {
            if (!defaultRolesArray.contains(rel)) {
                remove.add(rel);
                continue;
            }
            already.add(rel);
        }
        this.removeDefaultRoles(remove.toArray(new String[0]));
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
    }

    public void removeDefaultRoles(String ... var1);

    public static interface RoleRemovedEvent
    extends ProviderEvent {
        public RoleModel getRole();

        public KeycloakSession getKeycloakSession();
    }
}

