/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.federated;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;

public interface UserBrokerLinkFederatedStorage {
    public String getUserByFederatedIdentity(FederatedIdentityModel var1, RealmModel var2);

    public void addFederatedIdentity(RealmModel var1, String var2, FederatedIdentityModel var3);

    public boolean removeFederatedIdentity(RealmModel var1, String var2, String var3);

    public void preRemove(RealmModel var1, IdentityProviderModel var2);

    public void updateFederatedIdentity(RealmModel var1, String var2, FederatedIdentityModel var3);

    @Deprecated
    public Set<FederatedIdentityModel> getFederatedIdentities(String var1, RealmModel var2);

    default public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(String userId, RealmModel realm) {
        Set<FederatedIdentityModel> value = this.getFederatedIdentities(userId, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    public FederatedIdentityModel getFederatedIdentity(String var1, String var2, RealmModel var3);

    public static interface Streams
    extends UserBrokerLinkFederatedStorage {
        @Override
        default public Set<FederatedIdentityModel> getFederatedIdentities(String userId, RealmModel realm) {
            return this.getFederatedIdentitiesStream(userId, realm).collect(Collectors.toSet());
        }

        @Override
        public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(String var1, RealmModel var2);
    }
}

