/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Set;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.provider.Provider;

public interface RealmProvider
extends Provider,
ClientProvider {
    public MigrationModel getMigrationModel();

    public RealmModel createRealm(String var1);

    public RealmModel createRealm(String var1, String var2);

    public RealmModel getRealm(String var1);

    public RealmModel getRealmByName(String var1);

    public void moveGroup(RealmModel var1, GroupModel var2, GroupModel var3);

    public List<GroupModel> getGroups(RealmModel var1);

    public Long getGroupsCount(RealmModel var1, Boolean var2);

    public Long getGroupsCountByNameContaining(RealmModel var1, String var2);

    public List<GroupModel> getGroupsByRole(RealmModel var1, RoleModel var2, int var3, int var4);

    public List<GroupModel> getTopLevelGroups(RealmModel var1);

    public List<GroupModel> getTopLevelGroups(RealmModel var1, Integer var2, Integer var3);

    public List searchForGroupByName(RealmModel var1, String var2, Integer var3, Integer var4);

    public boolean removeGroup(RealmModel var1, GroupModel var2);

    public GroupModel createGroup(RealmModel var1, String var2);

    public GroupModel createGroup(RealmModel var1, String var2, String var3);

    public void addTopLevelGroup(RealmModel var1, GroupModel var2);

    public RoleModel addRealmRole(RealmModel var1, String var2);

    public RoleModel addRealmRole(RealmModel var1, String var2, String var3);

    public RoleModel getRealmRole(RealmModel var1, String var2);

    public Set<RoleModel> getRealmRoles(RealmModel var1);

    public boolean removeRole(RealmModel var1, RoleModel var2);

    public RoleModel getRoleById(String var1, RealmModel var2);

    public ClientScopeModel getClientScopeById(String var1, RealmModel var2);

    public GroupModel getGroupById(String var1, RealmModel var2);

    public List<RealmModel> getRealms();

    public List<RealmModel> getRealmsWithProviderType(Class<?> var1);

    public boolean removeRealm(String var1);

    @Override
    public void close();

    public ClientInitialAccessModel createClientInitialAccessModel(RealmModel var1, int var2, int var3);

    public ClientInitialAccessModel getClientInitialAccessModel(RealmModel var1, String var2);

    public void removeClientInitialAccessModel(RealmModel var1, String var2);

    public List<ClientInitialAccessModel> listClientInitialAccess(RealmModel var1);

    public void removeExpiredClientInitialAccess();

    public void decreaseRemainingCount(RealmModel var1, ClientInitialAccessModel var2);
}

