/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.admin.AuthorizationService;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientpolicy.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.ClientResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.validation.ClientValidator;
import org.keycloak.services.validation.PairwiseClientValidator;
import org.keycloak.services.validation.ValidationMessages;
import org.keycloak.validation.ClientValidationUtil;

public class ClientsResource {
    protected static final Logger logger = Logger.getLogger(ClientsResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;

    public ClientsResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<ClientRepresentation> getClients(@QueryParam(value="clientId") String clientId, @QueryParam(value="viewableOnly") @DefaultValue(value="false") boolean viewableOnly, @QueryParam(value="search") @DefaultValue(value="false") boolean search, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        List<ClientModel> clientModels;
        if (firstResult == null) {
            firstResult = -1;
        }
        if (maxResults == null) {
            maxResults = -1;
        }
        ArrayList<ClientRepresentation> rep = new ArrayList<ClientRepresentation>();
        boolean canView = this.auth.clients().canView();
        if (clientId == null || clientId.trim().equals("")) {
            clientModels = canView ? this.realm.getClients(firstResult, maxResults) : this.realm.getClients();
            this.auth.clients().requireList();
        } else {
            clientModels = Collections.emptyList();
            if (search) {
                clientModels = canView ? this.realm.searchClientByClientId(clientId, firstResult, maxResults) : this.realm.searchClientByClientId(clientId, Integer.valueOf(-1), Integer.valueOf(-1));
            } else {
                ClientModel client = this.realm.getClientByClientId(clientId);
                if (client != null) {
                    clientModels = Collections.singletonList(client);
                }
            }
        }
        int idx = 0;
        for (ClientModel clientModel : clientModels) {
            if (!canView && rep.size() == maxResults.intValue()) {
                return rep;
            }
            ClientRepresentation representation = null;
            if (canView || this.auth.clients().canView(clientModel)) {
                representation = ModelToRepresentation.toRepresentation((ClientModel)clientModel, (KeycloakSession)this.session);
                representation.setAccess(this.auth.clients().getAccess(clientModel));
            } else if (!viewableOnly && this.auth.clients().canView(clientModel)) {
                representation = new ClientRepresentation();
                representation.setId(clientModel.getId());
                representation.setClientId(clientModel.getClientId());
                representation.setDescription(clientModel.getDescription());
            }
            if (representation == null || !canView && idx++ < firstResult) continue;
            rep.add(representation);
        }
        return rep;
    }

    private AuthorizationService getAuthorizationService(ClientModel clientModel) {
        return new AuthorizationService(this.session, clientModel, this.auth, this.adminEvent);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createClient(ClientRepresentation rep) {
        this.auth.clients().requireManage();
        ValidationMessages validationMessages = new ValidationMessages();
        if (!ClientValidator.validate(rep, validationMessages) || !PairwiseClientValidator.validate(this.session, rep, validationMessages)) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(validationMessages.getStringMessages(), validationMessages.getStringMessages(messages), Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AdminClientRegisterContext(rep, this.auth.adminAuth()));
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        try {
            UserModel serviceAccount;
            ClientModel clientModel = ClientManager.createClient(this.session, this.realm, rep, true);
            if (Boolean.TRUE.equals(rep.isServiceAccountsEnabled()) && (serviceAccount = this.session.users().getServiceAccount(clientModel)) == null) {
                new ClientManager(new RealmManager(this.session)).enableServiceAccount(clientModel);
            }
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), clientModel.getId()).representation(rep).success();
            if (Boolean.TRUE.equals(rep.getAuthorizationServicesEnabled())) {
                AuthorizationService authorizationService = this.getAuthorizationService(clientModel);
                authorizationService.enable(true);
                ResourceServerRepresentation authorizationSettings = rep.getAuthorizationSettings();
                if (authorizationSettings != null) {
                    authorizationService.resourceServer().importSettings(authorizationSettings);
                }
            }
            ClientValidationUtil.validate((KeycloakSession)this.session, (ClientModel)clientModel, (boolean)true, c -> {
                this.session.getTransactionManager().setRollbackOnly();
                throw new ErrorResponseException("invalid_input", c.getError(), Response.Status.BAD_REQUEST);
            });
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(clientModel.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client " + rep.getClientId() + " already exists");
        }
    }

    @Path(value="{id}")
    public ClientResource getClient(@PathParam(value="id") String id) {
        ClientModel clientModel = this.realm.getClientById(id);
        if (clientModel == null) {
            if (this.auth.clients().canList()) {
                throw new NotFoundException("Could not find client");
            }
            throw new ForbiddenException();
        }
        this.session.getContext().setClient(clientModel);
        ClientResource clientResource = new ClientResource(this.realm, this.auth, clientModel, this.session, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientResource);
        return clientResource;
    }
}

