/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.DisplayTypeRequiredActionFactory;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.ConsoleUpdateProfile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.EventAuditingAttributeChangeListener;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class UpdateProfile
implements RequiredActionProvider,
RequiredActionFactory,
DisplayTypeRequiredActionFactory {
    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        context.challenge(this.createResponse(context, null, null));
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_PROFILE).detail("context", UserProfileContext.UPDATE_PROFILE.name());
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        UserModel user = context.getUser();
        UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, (Map)formData, user);
        try {
            profile.update(false, new AttributeChangeListener[]{new EventAuditingAttributeChangeListener(profile, event)});
            context.success();
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            context.challenge(this.createResponse(context, (MultivaluedMap<String, String>)formData, errors));
        }
    }

    protected UserModel.RequiredAction getResponseAction() {
        return UserModel.RequiredAction.UPDATE_PROFILE;
    }

    protected Response createResponse(RequiredActionContext context, MultivaluedMap<String, String> formData, List<FormMessage> errors) {
        LoginFormsProvider form = context.form();
        if (errors != null && !errors.isEmpty()) {
            form.setErrors(errors);
        }
        if (formData != null) {
            form = form.setFormData(formData);
        }
        return form.createResponse(this.getResponseAction());
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public RequiredActionProvider createDisplay(KeycloakSession session, String displayType) {
        if (displayType == null) {
            return this;
        }
        if (!"console".equalsIgnoreCase(displayType)) {
            return null;
        }
        return ConsoleUpdateProfile.SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Update Profile";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PROFILE.name();
    }
}

